/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.models;

import com.google.common.collect.Lists;
import io.castled.mapping.FixedGroupAppField;
import io.castled.mapping.PrimaryKeyGroupField;
import io.castled.mapping.QuestionnaireGroupField;
import io.castled.schema.mapping.MappingGroup;
import io.castled.utils.MappingGroupUtil;
import java.util.List;

public class MappingGroupAggregator {
    private List<MappingGroup> mappingGroups;

    public static Builder builder() {
        return new Builder();
    }

    public MappingGroupAggregator(List<MappingGroup> mappingGroups) {
        this.mappingGroups = mappingGroups;
    }

    public MappingGroupAggregator() {
    }

    public List<MappingGroup> getMappingGroups() {
        return this.mappingGroups;
    }

    public static class Builder {
        private final MappingGroupAggregator mappingGroupAggregator = new MappingGroupAggregator(Lists.newArrayList());

        public Builder addPrimaryKeyFields(List<PrimaryKeyGroupField> primaryKeys) {
            this.mappingGroupAggregator.getMappingGroups().add((MappingGroup)MappingGroupUtil.toPrimaryKeyFieldsGroup(primaryKeys));
            return this;
        }

        public Builder addQuestionnaireFields(List<QuestionnaireGroupField> questionnaireGroupFields) {
            this.mappingGroupAggregator.getMappingGroups().add((MappingGroup)MappingGroupUtil.toQuestionnaireGroupDTO(questionnaireGroupFields));
            return this;
        }

        public Builder addFixedAppFields(List<FixedGroupAppField> fixedGroupAppFields) {
            this.mappingGroupAggregator.getMappingGroups().add((MappingGroup)MappingGroupUtil.toFixedAppFieldsGroup(fixedGroupAppFields));
            return this;
        }

        public Builder addFixedAppFields(String title, String description, List<FixedGroupAppField> fixedGroupAppFields) {
            this.mappingGroupAggregator.getMappingGroups().add((MappingGroup)MappingGroupUtil.toFixedAppFieldsGroup(title, description, fixedGroupAppFields));
            return this;
        }

        public Builder addElasticAppFields(String title, String description, boolean autoMap, boolean pkRequired) {
            this.mappingGroupAggregator.getMappingGroups().add((MappingGroup)MappingGroupUtil.toElasticAppFieldsGroup(title, description, autoMap, pkRequired));
            return this;
        }

        public Builder addElasticAppFields(boolean autoMap, boolean pkRequired) {
            this.mappingGroupAggregator.getMappingGroups().add((MappingGroup)MappingGroupUtil.toElasticAppFieldsGroup(null, null, autoMap, pkRequired));
            return this;
        }

        public MappingGroupAggregator build() {
            return this.mappingGroupAggregator;
        }
    }
}

