/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.sendgrid;

import com.google.common.collect.Lists;
import io.castled.ObjectRegistry;
import io.castled.apps.connectors.sendgrid.SendgridAppConfig;
import io.castled.apps.connectors.sendgrid.SendgridUpsertError;
import io.castled.apps.connectors.sendgrid.dtos.BatchUpsertContactRequest;
import io.castled.apps.connectors.sendgrid.dtos.BatchUpsertJobIdResponse;
import io.castled.apps.connectors.sendgrid.dtos.BatchUpsertStatusResponse;
import io.castled.apps.connectors.sendgrid.dtos.ContactAttributesResponse;
import io.castled.apps.connectors.sendgrid.dtos.ContactList;
import io.castled.apps.connectors.sendgrid.dtos.ContactListsResponse;
import io.castled.exceptions.CastledRuntimeException;
import io.castled.utils.ThreadUtils;
import io.castled.utils.TimeUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendgridRestClient {
    private static final Logger log = LoggerFactory.getLogger(SendgridRestClient.class);
    private static final String API_ENDPOINT = "https://api.sendgrid.com/v3/";
    private final Client client = (Client)ObjectRegistry.getInstance(Client.class);
    private final SendgridAppConfig appConfig;

    public SendgridRestClient(SendgridAppConfig appConfig) {
        this.appConfig = appConfig;
    }

    public ContactAttributesResponse getContactAttributes() {
        return (ContactAttributesResponse)this.client.target(String.format("%s/marketing/field_definitions", API_ENDPOINT)).request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + this.appConfig.getApiKey())).get(ContactAttributesResponse.class);
    }

    public List<ContactList> getContactLists() {
        ArrayList contactLists = Lists.newArrayList();
        String currentUrl = String.format("%s/marketing/lists", API_ENDPOINT);
        while (currentUrl != null) {
            ContactListsResponse response = (ContactListsResponse)this.client.target(String.format("%s/marketing/lists", API_ENDPOINT)).request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + this.appConfig.getApiKey())).get(ContactListsResponse.class);
            contactLists.addAll(response.getResult());
            currentUrl = response.getMetadata().getNext();
        }
        return contactLists;
    }

    public List<SendgridUpsertError> upsertContacts(List<Map<String, Object>> contacts, String listId) {
        BatchUpsertStatusResponse statusResponse;
        BatchUpsertContactRequest batchRequest = this.constructBatchContactRequest(contacts, listId);
        BatchUpsertJobIdResponse batchUpsertResponse = (BatchUpsertJobIdResponse)this.client.target(String.format("%s/marketing/contacts", API_ENDPOINT)).request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + this.appConfig.getApiKey())).put(Entity.json((Object)batchRequest), BatchUpsertJobIdResponse.class);
        do {
            ThreadUtils.interruptIgnoredSleep((long)TimeUtils.secondsToMillis((long)2L));
        } while ("pending".equals((statusResponse = this.getBatchStatus(batchUpsertResponse.getJobId())).getStatus()));
        List<Object> upsertErrors = Lists.newArrayList();
        if ("errored".equals(statusResponse.getStatus()) || "failed".equals(statusResponse.getStatus())) {
            upsertErrors = this.createErrorResponse(statusResponse);
        }
        return upsertErrors;
    }

    private BatchUpsertContactRequest constructBatchContactRequest(List<Map<String, Object>> contacts, String listId) {
        ArrayList listIds = Lists.newArrayList();
        Optional.ofNullable(listId).map(listRef -> listIds.add(listRef));
        BatchUpsertContactRequest batchContactRequest = new BatchUpsertContactRequest(listIds, contacts);
        return batchContactRequest;
    }

    private List<SendgridUpsertError> createErrorResponse(BatchUpsertStatusResponse response) {
        String[] CSV_HEADER = new String[]{"primary_email", "contact_id", "errors_occurred"};
        InputStream errorStream = (InputStream)this.client.target(response.getResults().getErrorsUrl()).request(new String[]{"application/octet-stream"}).get(InputStream.class);
        ArrayList upsertErrors = Lists.newArrayList();
        try {
            CSVParser csvParser = new CSVParser((Reader)new InputStreamReader(errorStream), CSVFormat.DEFAULT.withFirstRecordAsHeader().withIgnoreHeaderCase().withTrim());
            for (CSVRecord csvRecord : csvParser) {
                String email = csvRecord.get(CSV_HEADER[0]);
                String message = csvRecord.get(CSV_HEADER[2]);
                upsertErrors.add(new SendgridUpsertError(email, message));
            }
        }
        catch (IOException e) {
            log.error(String.format("Creating error response from url:%s failed", response.getResults().getErrorsUrl()), (Throwable)e);
            throw new CastledRuntimeException((Throwable)e);
        }
        return upsertErrors;
    }

    private BatchUpsertStatusResponse getBatchStatus(String jobId) {
        return (BatchUpsertStatusResponse)this.client.target(String.format("%s/marketing/contacts/imports/%s", API_ENDPOINT, jobId)).request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + this.appConfig.getApiKey())).get(BatchUpsertStatusResponse.class);
    }
}

