/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.salesforce.client;

import com.google.common.collect.Lists;
import io.castled.ObjectRegistry;
import io.castled.apps.connectors.salesforce.SalesforceAccessConfig;
import io.castled.apps.connectors.salesforce.client.SFDCUtils;
import io.castled.apps.connectors.salesforce.client.dtos.Job;
import io.castled.apps.connectors.salesforce.client.dtos.JobRequest;
import io.castled.apps.connectors.salesforce.client.dtos.JobStateUpdateRequest;
import io.castled.apps.connectors.salesforce.client.dtos.SFDCObject;
import io.castled.apps.connectors.salesforce.client.dtos.SFDCObjectDetails;
import io.castled.apps.connectors.salesforce.client.dtos.SFDCObjectResult;
import io.castled.apps.connectors.salesforce.oauth.SalesforceAccessTokenRefresher;
import io.castled.core.WaitTimeAndRetry;
import io.castled.exceptions.CastledRuntimeException;
import io.castled.functionalinterfaces.ThrowingSupplier;
import io.castled.oauth.OAuthClientConfig;
import io.castled.oauth.OAuthDAO;
import io.castled.oauth.OAuthDetails;
import io.castled.utils.RetryUtils;
import java.util.List;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import org.jdbi.v3.core.Jdbi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SFDCRestClient {
    private static final Logger log = LoggerFactory.getLogger(SFDCRestClient.class);
    private final Client client;
    private final SalesforceAccessTokenRefresher accessTokenRefresher;
    private final Long oauthToken;
    private SalesforceAccessConfig salesforceAccessConfig;

    public SFDCRestClient(Long oauthToken, OAuthClientConfig oAuthClientConfig) {
        this.oauthToken = oauthToken;
        this.client = (Client)ObjectRegistry.getInstance(Client.class);
        OAuthDetails oAuthDetails = ((OAuthDAO)((Jdbi)ObjectRegistry.getInstance(Jdbi.class)).onDemand(OAuthDAO.class)).getOAuthDetails(oauthToken);
        this.salesforceAccessConfig = (SalesforceAccessConfig)oAuthDetails.getAccessConfig();
        this.accessTokenRefresher = new SalesforceAccessTokenRefresher(oAuthClientConfig);
    }

    public List<SFDCObject> getAllObjects() {
        return (List)this.executeRequest(() -> ((SFDCObjectResult)this.client.target(String.format("%s/sobjects/", SFDCUtils.getRestEndPoint(this.salesforceAccessConfig))).request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + this.salesforceAccessConfig.getAccessToken())).get(SFDCObjectResult.class)).getSObjects());
    }

    public SFDCObjectDetails getObjectDetails(String objectName) {
        return (SFDCObjectDetails)this.executeRequest(() -> (SFDCObjectDetails)this.client.target(String.format("%s/sobjects/%s/describe/", SFDCUtils.getRestEndPoint(this.salesforceAccessConfig), objectName)).request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + this.salesforceAccessConfig.getAccessToken())).get(SFDCObjectDetails.class));
    }

    public Job createJob(JobRequest jobRequest) {
        return (Job)this.executeRequest(() -> (Job)this.client.target(String.format("%s/jobs/ingest", SFDCUtils.getRestEndPoint(this.salesforceAccessConfig))).request().header("Authorization", (Object)("Bearer " + this.salesforceAccessConfig.getAccessToken())).post(Entity.json((Object)jobRequest), Job.class));
    }

    public void uploadCsv(String jobId, String csvContent) {
        this.executeRequest(() -> this.client.target(String.format("%s/jobs/ingest/%s/batches", SFDCUtils.getRestEndPoint(this.salesforceAccessConfig), jobId)).request().header("Authorization", (Object)("Bearer " + this.salesforceAccessConfig.getAccessToken())).put(Entity.entity((Object)csvContent, (String)"text/csv")));
    }

    public Job updateJobState(String jobId, JobStateUpdateRequest jobStateUpdateRequest) {
        return (Job)this.executeRequest(() -> (Job)this.client.target(String.format("%s/jobs/ingest/%s", SFDCUtils.getRestEndPoint(this.salesforceAccessConfig), jobId)).request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + this.salesforceAccessConfig.getAccessToken())).method("PATCH", Entity.json((Object)jobStateUpdateRequest), Job.class));
    }

    public Job getJob(String jobId) {
        return (Job)this.executeRequest(() -> (Job)this.client.target(String.format("%s/jobs/ingest/%s", SFDCUtils.getRestEndPoint(this.salesforceAccessConfig), jobId)).request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + this.salesforceAccessConfig.getAccessToken())).get(Job.class));
    }

    public String getFailedReport(String jobId) {
        return (String)this.executeRequest(() -> (String)this.client.target(String.format("%s/jobs/ingest/%s/failedResults", SFDCUtils.getRestEndPoint(this.salesforceAccessConfig), jobId)).request(new String[]{"text/plain"}).header("Authorization", (Object)("Bearer " + this.salesforceAccessConfig.getAccessToken())).get(String.class));
    }

    private <T> T executeRequest(ThrowingSupplier<T> supplier) {
        try {
            return (T)RetryUtils.retrySupplier(supplier, (int)1, (List)Lists.newArrayList((Object[])new Class[]{NotAuthorizedException.class}), (throwable, attempts) -> {
                this.salesforceAccessConfig = this.accessTokenRefresher.refreshAndPersistAccessConfig(this.oauthToken);
                return new WaitTimeAndRetry(0L, true);
            });
        }
        catch (Exception e) {
            throw new CastledRuntimeException((Throwable)e);
        }
    }
}

