/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.salesforce.client;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.castled.apps.connectors.salesforce.client.dtos.SFDCIdResponse;
import io.castled.apps.connectors.salesforce.client.dtos.SFDCTokenResponse;
import io.castled.exceptions.CastledRuntimeException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;

@Singleton
public class SFDCAuthClient {
    private static final String TOKEN_SERVICE_END_POINT = "https://login.salesforce.com/services/oauth2/token";
    private final Client client;

    @Inject
    public SFDCAuthClient(Client client) {
        this.client = client;
    }

    public SFDCTokenResponse getTokenViaAuthorizationCode(String authorizationCode, String clientId, String clientSecret, String redirectUri) {
        Response response = this.client.target(TOKEN_SERVICE_END_POINT).queryParam("code", new Object[]{authorizationCode}).queryParam("grant_type", new Object[]{"authorization_code"}).queryParam("client_id", new Object[]{clientId}).queryParam("client_secret", new Object[]{clientSecret}).queryParam("redirect_uri", new Object[]{redirectUri}).request(new String[]{"application/json"}).post(Entity.json(null));
        SFDCTokenResponse sfdcTokenResponse = (SFDCTokenResponse)response.readEntity(SFDCTokenResponse.class);
        if (sfdcTokenResponse.getError() != null) {
            throw new CastledRuntimeException(sfdcTokenResponse.getError());
        }
        return sfdcTokenResponse;
    }

    public SFDCIdResponse getSFDCIdResponse(String url, String accessToken) {
        return (SFDCIdResponse)this.client.target(url).request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + accessToken)).get(SFDCIdResponse.class);
    }

    public SFDCTokenResponse getTokenViaRefreshToken(String refreshToken, String clientId, String clientSecret) {
        Response response = this.client.target(TOKEN_SERVICE_END_POINT).queryParam("grant_type", new Object[]{"refresh_token"}).queryParam("client_id", new Object[]{clientId}).queryParam("client_secret", new Object[]{clientSecret}).queryParam("refresh_token", new Object[]{refreshToken}).request(new String[]{"application/json"}).post(Entity.json(null));
        SFDCTokenResponse sfdcTokenResponse = (SFDCTokenResponse)response.readEntity(SFDCTokenResponse.class);
        if (sfdcTokenResponse.getError() != null) {
            throw new CastledRuntimeException(sfdcTokenResponse.getError());
        }
        return sfdcTokenResponse;
    }
}

