/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.salesforce;

import io.castled.oauth.OAuthAccessConfig;
import io.castled.oauth.OAuthServiceType;

public class SalesforceAccessConfig
extends OAuthAccessConfig {
    private String instanceUrl;
    private String userName;
    private String displayName;

    public SalesforceAccessConfig(String instanceUrl, String userName, String displayName, String accessToken, String refreshToken) {
        super(OAuthServiceType.SALESFORCE, accessToken, refreshToken);
        this.instanceUrl = instanceUrl;
        this.userName = userName;
        this.displayName = displayName;
    }

    public static SalesforceAccessConfigBuilder builder() {
        return new SalesforceAccessConfigBuilder();
    }

    public String getInstanceUrl() {
        return this.instanceUrl;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public SalesforceAccessConfig() {
    }

    public static class SalesforceAccessConfigBuilder {
        private String instanceUrl;
        private String userName;
        private String displayName;
        private String accessToken;
        private String refreshToken;

        SalesforceAccessConfigBuilder() {
        }

        public SalesforceAccessConfigBuilder instanceUrl(String instanceUrl) {
            this.instanceUrl = instanceUrl;
            return this;
        }

        public SalesforceAccessConfigBuilder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public SalesforceAccessConfigBuilder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public SalesforceAccessConfigBuilder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public SalesforceAccessConfigBuilder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public SalesforceAccessConfig build() {
            return new SalesforceAccessConfig(this.instanceUrl, this.userName, this.displayName, this.accessToken, this.refreshToken);
        }

        public String toString() {
            return "SalesforceAccessConfig.SalesforceAccessConfigBuilder(instanceUrl=" + this.instanceUrl + ", userName=" + this.userName + ", displayName=" + this.displayName + ", accessToken=" + this.accessToken + ", refreshToken=" + this.refreshToken + ")";
        }
    }
}

