/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.restapi;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.MustacheException;
import com.google.common.collect.Lists;
import io.castled.apps.connectors.restapi.InvalidTemplateException;
import io.castled.apps.connectors.restapi.RestApiAppSyncConfig;
import io.castled.utils.JsonUtils;
import io.castled.utils.StringUtils;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.BadRequestException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class RestApiTemplateParser {
    private static final char TEMPLATE_START = '{';
    private static final char TEMPLATE_END = '}';

    public String resolveTemplateString(String mustacheTemplate, Map<String, Object> inputMap) {
        String cleanedTemplate = this.cleanMustacheJson(mustacheTemplate);
        StringWriter writer = new StringWriter();
        block0: for (int i = 0; i < cleanedTemplate.length(); ++i) {
            if (cleanedTemplate.charAt(i) == '{' && cleanedTemplate.charAt(i + 1) == '{') {
                StringWriter templateVariable = new StringWriter();
                for (int j = i + 2; j < cleanedTemplate.length(); ++j) {
                    if (cleanedTemplate.charAt(j) == '}' && cleanedTemplate.charAt(j + 1) == '}') {
                        Object templateValue = inputMap.get(templateVariable.toString());
                        if (templateValue instanceof String) {
                            writer.append(StringUtils.quoteText((String)((String)templateValue)));
                        } else {
                            writer.append(templateValue.toString());
                        }
                        i = j + 1;
                        continue block0;
                    }
                    templateVariable.append(cleanedTemplate.charAt(j));
                }
                continue;
            }
            writer.append(cleanedTemplate.charAt(i));
        }
        return writer.toString();
    }

    public Map<String, Object> resolveTemplate(String mustacheTemplate, Map<String, Object> inputMap) {
        return JsonUtils.jsonStringToMap((String)this.resolveTemplateString(mustacheTemplate, inputMap));
    }

    public List<String> getTemplateVariables(String mustacheTemplate) {
        String cleanedTemplate = mustacheTemplate.replaceAll("\\s+", "");
        ArrayList templateVariables = Lists.newArrayList();
        block0: for (int i = 0; i < cleanedTemplate.length(); ++i) {
            if (i == cleanedTemplate.length() - 1) {
                return templateVariables;
            }
            if (cleanedTemplate.charAt(i) != '{' || cleanedTemplate.charAt(i + 1) != '{') continue;
            StringWriter templateVariable = new StringWriter();
            for (int j = i + 2; j < cleanedTemplate.length(); ++j) {
                if (cleanedTemplate.charAt(j) == '}' && cleanedTemplate.charAt(j + 1) == '}') {
                    templateVariables.add(templateVariable.toString());
                    i = j + 1;
                    continue block0;
                }
                templateVariable.append(cleanedTemplate.charAt(j));
            }
        }
        return templateVariables;
    }

    public BulkMustacheTokenizedResponse tokenizeBulkMustacheJson(String bulkMustacheJson, String arrayPath) throws InvalidTemplateException {
        String cleanedJson = this.cleanMustacheJson(bulkMustacheJson);
        List<String> templateVariables = this.getTemplateVariables(cleanedJson);
        Map<String, Object> valuesMap = templateVariables.stream().collect(Collectors.toMap(template -> template, template -> String.format("{{%s}}", template)));
        JsonNode jsonNode = JsonUtils.jsonStringToJsonNode((String)this.resolveTemplateString(cleanedJson, valuesMap));
        for (String token : arrayPath.split("\\.")) {
            if ((jsonNode = jsonNode.get(token)) != null && !jsonNode.isNull()) continue;
            throw new InvalidTemplateException(String.format("No object found at path %s", arrayPath));
        }
        if (!jsonNode.isArray()) {
            throw new InvalidTemplateException(String.format("No Json Array found at path %s", arrayPath));
        }
        ArrayNode arrayNode = (ArrayNode)jsonNode;
        if (arrayNode.size() == 0) {
            throw new InvalidTemplateException(String.format("Json Array found at path %s cannot be empty", arrayPath));
        }
        if (arrayNode.size() > 1) {
            throw new InvalidTemplateException(String.format("Json Array found at path %s should contain exactly one element", arrayPath));
        }
        JsonNode templateNode = arrayNode.get(0);
        if (!templateNode.isObject()) {
            throw new InvalidTemplateException("Json Array found at path %s should be an array of json objects");
        }
        String templateJson = this.cleanMustacheJson(templateNode.toString());
        String templateArrayJson = this.cleanMustacheJson(arrayNode.toString());
        int templateArrayIndex = cleanedJson.indexOf(templateArrayJson);
        String templateArrayPrefix = cleanedJson.substring(0, templateArrayIndex);
        String templateArraySuffix = cleanedJson.substring(templateArrayIndex + templateArrayJson.length());
        return new BulkMustacheTokenizedResponse(templateArrayPrefix, templateArraySuffix, templateJson);
    }

    public String cleanMustacheJson(String mustacheJson) {
        mustacheJson = mustacheJson.replaceAll("\\s+", "");
        StringWriter cleanedJson = new StringWriter();
        for (int i = 0; i < mustacheJson.length(); ++i) {
            if (mustacheJson.charAt(i) == '\"' && (i < mustacheJson.length() - 2 && mustacheJson.charAt(i + 1) == '{' && mustacheJson.charAt(i + 2) == '{' || i >= 2 && mustacheJson.charAt(i - 1) == '}' && mustacheJson.charAt(i - 2) == '}')) continue;
            cleanedJson.append(mustacheJson.charAt(i));
        }
        return cleanedJson.toString();
    }

    public void validateMustacheJson(String mustacheJson, RestApiAppSyncConfig restApiAppSyncConfig) throws InvalidTemplateException {
        block4: {
            this.validatePayload(mustacheJson);
            List<String> templateVariables = this.getTemplateVariables(mustacheJson);
            if (CollectionUtils.isEmpty(templateVariables)) {
                throw new InvalidTemplateException("Template String should contain atleast one template variable");
            }
            Map<String, Object> valuesMap = templateVariables.stream().collect(Collectors.toMap(template -> template, template -> "dummy"));
            try {
                this.resolveTemplate(mustacheJson, valuesMap);
            }
            catch (Exception e) {
                if (!(ExceptionUtils.getRootCause((Throwable)e) instanceof JsonParseException)) break block4;
                throw new InvalidTemplateException(String.format("Json Invalid: %s", ExceptionUtils.getRootCauseMessage((Throwable)e)));
            }
        }
        if (restApiAppSyncConfig.isBulk()) {
            this.tokenizeBulkMustacheJson(mustacheJson, restApiAppSyncConfig.getJsonPath());
        }
    }

    public void validatePayload(String payloadTemplate) {
        try {
            new DefaultMustacheFactory().compile((Reader)new StringReader(payloadTemplate), "template.output");
        }
        catch (MustacheException e) {
            throw new BadRequestException(e.getMessage());
        }
    }

    public static class BulkMustacheTokenizedResponse {
        private String arrayPrefix;
        private String arraySuffix;
        private String recordTemplate;

        public String getArrayPrefix() {
            return this.arrayPrefix;
        }

        public String getArraySuffix() {
            return this.arraySuffix;
        }

        public String getRecordTemplate() {
            return this.recordTemplate;
        }

        public void setArrayPrefix(String arrayPrefix) {
            this.arrayPrefix = arrayPrefix;
        }

        public void setArraySuffix(String arraySuffix) {
            this.arraySuffix = arraySuffix;
        }

        public void setRecordTemplate(String recordTemplate) {
            this.recordTemplate = recordTemplate;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BulkMustacheTokenizedResponse)) {
                return false;
            }
            BulkMustacheTokenizedResponse other = (BulkMustacheTokenizedResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$arrayPrefix = this.getArrayPrefix();
            String other$arrayPrefix = other.getArrayPrefix();
            if (this$arrayPrefix == null ? other$arrayPrefix != null : !this$arrayPrefix.equals(other$arrayPrefix)) {
                return false;
            }
            String this$arraySuffix = this.getArraySuffix();
            String other$arraySuffix = other.getArraySuffix();
            if (this$arraySuffix == null ? other$arraySuffix != null : !this$arraySuffix.equals(other$arraySuffix)) {
                return false;
            }
            String this$recordTemplate = this.getRecordTemplate();
            String other$recordTemplate = other.getRecordTemplate();
            return !(this$recordTemplate == null ? other$recordTemplate != null : !this$recordTemplate.equals(other$recordTemplate));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BulkMustacheTokenizedResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $arrayPrefix = this.getArrayPrefix();
            result = result * 59 + ($arrayPrefix == null ? 43 : $arrayPrefix.hashCode());
            String $arraySuffix = this.getArraySuffix();
            result = result * 59 + ($arraySuffix == null ? 43 : $arraySuffix.hashCode());
            String $recordTemplate = this.getRecordTemplate();
            result = result * 59 + ($recordTemplate == null ? 43 : $recordTemplate.hashCode());
            return result;
        }

        public String toString() {
            return "RestApiTemplateParser.BulkMustacheTokenizedResponse(arrayPrefix=" + this.getArrayPrefix() + ", arraySuffix=" + this.getArraySuffix() + ", recordTemplate=" + this.getRecordTemplate() + ")";
        }

        public BulkMustacheTokenizedResponse(String arrayPrefix, String arraySuffix, String recordTemplate) {
            this.arrayPrefix = arrayPrefix;
            this.arraySuffix = arraySuffix;
            this.recordTemplate = recordTemplate;
        }

        public BulkMustacheTokenizedResponse() {
        }
    }
}

