/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.restapi;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.castled.ObjectRegistry;
import io.castled.apps.connectors.restapi.ErrorAndCode;
import io.castled.apps.connectors.restapi.InvalidTemplateException;
import io.castled.apps.connectors.restapi.RestApiAppSyncConfig;
import io.castled.apps.connectors.restapi.RestApiCustomErrorCodes;
import io.castled.apps.connectors.restapi.RestApiTemplateParser;
import io.castled.exceptions.CastledRuntimeException;
import io.castled.models.TargetRestApiMapping;
import io.castled.utils.JsonUtils;
import io.castled.utils.ResponseUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestApiTemplateClient {
    private static final Logger log = LoggerFactory.getLogger(RestApiTemplateClient.class);
    public static final String CONTENT_TYPE = "Content-Type";
    private final Client client = (Client)ObjectRegistry.getInstance(Client.class);
    private final TargetRestApiMapping targetTemplateMapping;
    private final RestApiAppSyncConfig restApiAppSyncConfig;

    public RestApiTemplateClient(TargetRestApiMapping targetTemplateMapping, RestApiAppSyncConfig restApiAppSyncConfig) {
        this.targetTemplateMapping = targetTemplateMapping;
        this.restApiAppSyncConfig = restApiAppSyncConfig;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ErrorAndCode upsertDetails(List<Map<String, Object>> details) {
        try (Response response = this.invokeRestAPI(details);){
            if (!ResponseUtils.is2xx((Response)response)) {
                String errorMessage = (String)response.readEntity(String.class);
                ErrorAndCode errorAndCode2 = new ErrorAndCode(String.valueOf(response.getStatus()), errorMessage);
                return errorAndCode2;
            }
            ErrorAndCode errorAndCode = null;
            return errorAndCode;
        }
        catch (Exception e) {
            log.error(String.format("Custom API upsert failed for %s %s", this.targetTemplateMapping.getUrl(), this.targetTemplateMapping.getTemplate()), (Throwable)e);
            return new ErrorAndCode(RestApiCustomErrorCodes.UNCLASSIFIED.name(), e.getMessage());
        }
    }

    private Response invokeRestAPI(List<Map<String, Object>> inputDetails) throws InvalidTemplateException {
        Map<String, String> headers = this.targetTemplateMapping.getHeaders();
        Invocation.Builder builder = this.client.target(this.targetTemplateMapping.getUrl()).request();
        headers.forEach((arg_0, arg_1) -> ((Invocation.Builder)builder).header(arg_0, arg_1));
        switch (this.targetTemplateMapping.getMethod()) {
            case PUT: {
                return builder.put(Entity.json(this.constructPayload(inputDetails)));
            }
            case POST: {
                return builder.post(Entity.json(this.constructPayload(inputDetails)));
            }
        }
        throw new CastledRuntimeException(String.format("Unsupported rest method %s", new Object[]{this.targetTemplateMapping.getMethod()}));
    }

    private Map<String, Object> constructPayload(List<Map<String, Object>> inputDetails) throws InvalidTemplateException {
        RestApiTemplateParser restApiTemplateParser = new RestApiTemplateParser();
        if (this.restApiAppSyncConfig.isBulk()) {
            RestApiTemplateParser.BulkMustacheTokenizedResponse tokenizedResponse = restApiTemplateParser.tokenizeBulkMustacheJson(this.targetTemplateMapping.getTemplate(), this.restApiAppSyncConfig.getJsonPath());
            ArrayList transformedInput = Lists.newArrayList();
            for (Map<String, Object> inputDetail : inputDetails) {
                transformedInput.add(restApiTemplateParser.resolveTemplate(tokenizedResponse.getRecordTemplate(), inputDetail));
            }
            return JsonUtils.jsonStringToMap((String)String.format("%s%s%s", tokenizedResponse.getArrayPrefix(), JsonUtils.objectToString((Object)transformedInput), tokenizedResponse.getArraySuffix()));
        }
        return restApiTemplateParser.resolveTemplate(this.targetTemplateMapping.getTemplate(), inputDetails.get(0));
    }

    private Map<String, Object> constructNestedMap(String nestedPath, List<Map<String, Object>> transformedInput) {
        HashMap parentMap;
        String[] pathTokens = nestedPath.split("\\.");
        Map enclosedMap = parentMap = Maps.newHashMap();
        for (int i = 0; i < pathTokens.length; ++i) {
            if (i == pathTokens.length - 1) {
                enclosedMap.put(pathTokens[i], transformedInput);
                continue;
            }
            enclosedMap.put(pathTokens[i], Maps.newHashMap());
            enclosedMap = (Map)enclosedMap.get(pathTokens[i]);
        }
        return parentMap;
    }
}

