/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.mixpanel;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Singleton;
import io.castled.ObjectRegistry;
import io.castled.apps.connectors.mixpanel.MixpanelAppConfig;
import io.castled.apps.connectors.mixpanel.MixpanelErrorParser;
import io.castled.apps.connectors.mixpanel.MixpanelObjectFields;
import io.castled.apps.connectors.mixpanel.MixpanelObjectSink;
import io.castled.apps.connectors.mixpanel.MixpanelRestClient;
import io.castled.apps.connectors.mixpanel.dto.UserProfileAndError;
import io.castled.apps.models.DataSinkRequest;
import io.castled.commons.errors.errorclassifications.UnclassifiedError;
import io.castled.commons.models.DataSinkMessage;
import io.castled.commons.models.MessageSyncStats;
import io.castled.commons.streams.ErrorOutputStream;
import io.castled.core.CastledOffsetListQueue;
import io.castled.schema.models.Field;
import io.castled.schema.models.Tuple;
import io.castled.utils.TimeUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MixpanelUserProfileSink
extends MixpanelObjectSink<DataSinkMessage> {
    private static final Logger log = LoggerFactory.getLogger(MixpanelUserProfileSink.class);
    private final MixpanelRestClient mixpanelRestClient;
    private final MixpanelErrorParser mixpanelErrorParser;
    private final ErrorOutputStream errorOutputStream;
    private final MixpanelAppConfig mixpanelAppConfig;
    private final AtomicLong processedRecords = new AtomicLong(0L);
    private long lastProcessedOffset = 0L;
    private final AtomicLong failedRecords = new AtomicLong(0L);
    private final CastledOffsetListQueue<DataSinkMessage> requestsBuffer = new CastledOffsetListQueue((Consumer)new UpsertUserProfileConsumer(), 10, 10, true);

    public MixpanelUserProfileSink(DataSinkRequest dataSinkRequest) {
        this.mixpanelRestClient = new MixpanelRestClient(((MixpanelAppConfig)dataSinkRequest.getExternalApp().getConfig()).getProjectToken(), ((MixpanelAppConfig)dataSinkRequest.getExternalApp().getConfig()).getApiSecret());
        this.errorOutputStream = dataSinkRequest.getErrorOutputStream();
        this.mixpanelErrorParser = (MixpanelErrorParser)ObjectRegistry.getInstance(MixpanelErrorParser.class);
        this.mixpanelAppConfig = (MixpanelAppConfig)dataSinkRequest.getExternalApp().getConfig();
    }

    @Override
    protected void writeRecords(List<DataSinkMessage> messages) {
        try {
            this.requestsBuffer.writePayload((List)Lists.newArrayList(messages), 5, TimeUnit.MINUTES);
        }
        catch (TimeoutException e) {
            log.error("Unable to publish records to records queue", (Throwable)e);
            for (DataSinkMessage record : messages) {
                this.errorOutputStream.writeFailedRecord(record, new UnclassifiedError("Internal error!! Unable to publish records to records queue. Please contact support"));
            }
        }
    }

    private Object getDistinctID(Tuple record) {
        return record.getValue(MixpanelObjectFields.USER_PROFILE_FIELDS.DISTINCT_ID.getFieldName());
    }

    private Map<String, Object> constructUserProfileDetails(Tuple record) {
        Object distinctID = record.getValue(MixpanelObjectFields.USER_PROFILE_FIELDS.DISTINCT_ID.getFieldName());
        HashMap userProfileInfo = Maps.newHashMap();
        userProfileInfo.put("$token", this.mixpanelAppConfig.getProjectToken());
        userProfileInfo.put("$distinct_id", distinctID);
        userProfileInfo.put("$set", this.constructPropertyMap(record));
        return userProfileInfo;
    }

    private Map<String, Object> constructPropertyMap(Tuple record) {
        Map<String, Object> nonReservedPropertyMap;
        HashMap propertyMap = Maps.newHashMap();
        Map<String, Object> reservedPropertyMap = record.getFields().stream().filter(field -> this.isMixpanelReservedKeyword(field.getName())).collect(Collectors.toMap(field -> "$" + field.getName(), Field::getValue));
        if (!reservedPropertyMap.isEmpty()) {
            propertyMap.putAll(reservedPropertyMap);
        }
        if (!(nonReservedPropertyMap = record.getFields().stream().filter(field -> !this.isMixpanelReservedKeyword(field.getName())).collect(Collectors.toMap(Field::getName, Field::getValue))).isEmpty()) {
            propertyMap.putAll(nonReservedPropertyMap);
        }
        return propertyMap;
    }

    private boolean isMixpanelReservedKeyword(String fieldName) {
        return this.getReservedKeywords().contains(fieldName);
    }

    private List<String> getReservedKeywords() {
        return Lists.newArrayList((Object[])new String[]{"region", "timezone", "country_code", "last_seen", "city", "first_name", "last_name", "email"});
    }

    @Override
    public MessageSyncStats getSyncStats() {
        return new MessageSyncStats(this.processedRecords.get(), this.lastProcessedOffset);
    }

    @Override
    public long getMaxBufferedObjects() {
        return 200L;
    }

    @Override
    public void flushRecords() throws Exception {
        super.flushRecords();
        this.requestsBuffer.flush(TimeUtils.minutesToMillis((long)10L));
    }

    private void processBulkUserProfileUpdate(List<DataSinkMessage> messages) {
        List<UserProfileAndError> failedRecords = this.mixpanelRestClient.upsertUserProfileDetails(messages.stream().map(DataSinkMessage::getRecord).map(this::constructUserProfileDetails).collect(Collectors.toList()));
        Map userProfileRecordMapper = messages.stream().filter(message -> this.getDistinctID(message.getRecord()) != null).collect(Collectors.toMap(message -> this.getDistinctID(message.getRecord()), Function.identity()));
        failedRecords.forEach(failedRecord -> failedRecord.getFailureReasons().forEach(failureReason -> this.errorOutputStream.writeFailedRecord((DataSinkMessage)userProfileRecordMapper.get(failedRecord.getDistinctID()), this.mixpanelErrorParser.getPipelineError((String)failureReason))));
        this.processedRecords.addAndGet(messages.size());
        this.lastProcessedOffset = Math.max(this.lastProcessedOffset, ((DataSinkMessage)Iterables.getLast(messages)).getOffset());
    }

    private class UpsertUserProfileConsumer
    implements Consumer<List<DataSinkMessage>> {
        private UpsertUserProfileConsumer() {
        }

        @Override
        public void accept(List<DataSinkMessage> messages) {
            if (CollectionUtils.isEmpty(messages)) {
                return;
            }
            MixpanelUserProfileSink.this.processBulkUserProfileUpdate(messages);
        }
    }
}

