/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.mixpanel;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Singleton;
import io.castled.ObjectRegistry;
import io.castled.apps.connectors.mixpanel.MixpanelAppConfig;
import io.castled.apps.connectors.mixpanel.MixpanelAppSyncConfig;
import io.castled.apps.connectors.mixpanel.MixpanelErrorParser;
import io.castled.apps.connectors.mixpanel.MixpanelObjectFields;
import io.castled.apps.connectors.mixpanel.MixpanelObjectSink;
import io.castled.apps.connectors.mixpanel.MixpanelRestClient;
import io.castled.apps.connectors.mixpanel.dto.EventAndError;
import io.castled.apps.models.DataSinkRequest;
import io.castled.commons.errors.errorclassifications.UnclassifiedError;
import io.castled.commons.models.DataSinkMessage;
import io.castled.commons.models.MessageSyncStats;
import io.castled.commons.streams.ErrorOutputStream;
import io.castled.core.CastledOffsetListQueue;
import io.castled.schema.models.Field;
import io.castled.schema.models.Tuple;
import io.castled.utils.TimeUtils;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MixpanelEventSink
extends MixpanelObjectSink<DataSinkMessage> {
    private static final Logger log = LoggerFactory.getLogger(MixpanelEventSink.class);
    private final MixpanelRestClient mixpanelRestClient;
    private final MixpanelErrorParser mixpanelErrorParser;
    private final ErrorOutputStream errorOutputStream;
    private final MixpanelAppSyncConfig mixpanelAppSyncConfig;
    private final AtomicLong processedRecords = new AtomicLong(0L);
    private final CastledOffsetListQueue<DataSinkMessage> requestsBuffer = new CastledOffsetListQueue((Consumer)new CreateEventConsumer(), 10, 10, true);
    private long lastProcessedOffset = 0L;

    public MixpanelEventSink(DataSinkRequest dataSinkRequest) {
        this.mixpanelRestClient = new MixpanelRestClient(((MixpanelAppConfig)dataSinkRequest.getExternalApp().getConfig()).getProjectToken(), ((MixpanelAppConfig)dataSinkRequest.getExternalApp().getConfig()).getApiSecret());
        this.mixpanelAppSyncConfig = (MixpanelAppSyncConfig)dataSinkRequest.getAppSyncConfig();
        this.errorOutputStream = dataSinkRequest.getErrorOutputStream();
        this.mixpanelErrorParser = (MixpanelErrorParser)ObjectRegistry.getInstance(MixpanelErrorParser.class);
    }

    private void processBulkEventCreation(List<DataSinkMessage> messages) {
        List<EventAndError> failedRecords = this.mixpanelRestClient.insertEventDetails(messages.stream().map(DataSinkMessage::getRecord).map(this::constructEventDetails).collect(Collectors.toList()));
        Map eventIDMapper = messages.stream().filter(message -> this.getEventID(message.getRecord()) != null).collect(Collectors.toMap(message -> this.getEventID(message.getRecord()), Function.identity()));
        failedRecords.forEach(failedRecord -> failedRecord.getFailureReasons().forEach(failureReason -> this.errorOutputStream.writeFailedRecord((DataSinkMessage)eventIDMapper.get(failedRecord.getInsertId()), this.mixpanelErrorParser.getPipelineError((String)failureReason))));
        this.processedRecords.addAndGet(messages.size());
        this.lastProcessedOffset = Math.max(this.lastProcessedOffset, ((DataSinkMessage)Iterables.getLast(messages)).getOffset());
    }

    @Override
    protected void writeRecords(List<DataSinkMessage> messages) {
        try {
            this.requestsBuffer.writePayload((List)Lists.newArrayList(messages), 5, TimeUnit.MINUTES);
        }
        catch (TimeoutException e) {
            log.error("Unable to publish records to records queue", (Throwable)e);
            for (DataSinkMessage record : messages) {
                this.errorOutputStream.writeFailedRecord(record, new UnclassifiedError("Internal error!! Unable to publish records to records queue. Please contact support"));
            }
        }
    }

    private Object getEventID(Tuple record) {
        return record.getValue(MixpanelObjectFields.EVENT_FIELDS.INSERT_ID.getFieldName());
    }

    private Map<String, Object> constructEventDetails(Tuple record) {
        HashMap eventInfo = Maps.newHashMap();
        eventInfo.put("event", this.mixpanelAppSyncConfig.getEventName());
        HashMap propertiesMap = Maps.newHashMap();
        propertiesMap.put("$" + MixpanelObjectFields.EVENT_FIELDS.INSERT_ID.getFieldName(), record.getValue(MixpanelObjectFields.EVENT_FIELDS.INSERT_ID.getFieldName()));
        propertiesMap.put(MixpanelObjectFields.EVENT_FIELDS.DISTINCT_ID.getFieldName(), Optional.ofNullable(record.getValue(MixpanelObjectFields.EVENT_FIELDS.DISTINCT_ID.getFieldName())).orElse(""));
        propertiesMap.put(MixpanelObjectFields.EVENT_FIELDS.EVENT_TIMESTAMP.getFieldName(), this.convertTimeStampToEpoch(record.getValue(MixpanelObjectFields.EVENT_FIELDS.EVENT_TIMESTAMP.getFieldName())));
        propertiesMap.put(MixpanelObjectFields.EVENT_FIELDS.GEO_IP.getFieldName(), record.getValue(MixpanelObjectFields.EVENT_FIELDS.GEO_IP.getFieldName()));
        propertiesMap.putAll(record.getFields().stream().filter(field -> !this.isMixpanelReservedKeyword(field.getName())).collect(Collectors.toMap(Field::getName, field -> this.transformFieldValue(field.getValue()))));
        eventInfo.put("properties", propertiesMap);
        return eventInfo;
    }

    private String transformFieldValue(Object object) {
        if (object instanceof Integer || object instanceof Long) {
            return String.valueOf(object);
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof LocalDate) {
            return ((LocalDate)object).format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        }
        if (object instanceof LocalDateTime) {
            return ((LocalDateTime)object).format(DateTimeFormatter.ofPattern("yyyy-MM-ddTHH:mm:ssZ"));
        }
        if (object instanceof ZonedDateTime) {
            return ((ZonedDateTime)object).format(DateTimeFormatter.ofPattern("yyyy-MM-ddTHH:mm:ssZ"));
        }
        if (object instanceof Boolean) {
            return Boolean.toString((Boolean)object);
        }
        return "";
    }

    private Long convertTimeStampToEpoch(Object timestamp) {
        if (timestamp instanceof LocalDateTime) {
            return ((LocalDateTime)timestamp).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        }
        if (timestamp instanceof ZonedDateTime) {
            return ((ZonedDateTime)timestamp).toInstant().toEpochMilli();
        }
        return null;
    }

    private boolean isMixpanelReservedKeyword(String fieldName) {
        return this.getReservedKeywords().contains(fieldName);
    }

    private List<String> getReservedKeywords() {
        return Lists.newArrayList((Object[])new String[]{"event", "time", "distinct_id", "insert_id", "ip"});
    }

    @Override
    public void flushRecords() throws Exception {
        super.flushRecords();
        this.requestsBuffer.flush(TimeUtils.minutesToMillis((long)10L));
    }

    @Override
    public MessageSyncStats getSyncStats() {
        return new MessageSyncStats(this.processedRecords.get(), this.lastProcessedOffset);
    }

    @Override
    public long getMaxBufferedObjects() {
        return 2000L;
    }

    private class CreateEventConsumer
    implements Consumer<List<DataSinkMessage>> {
        private CreateEventConsumer() {
        }

        @Override
        public void accept(List<DataSinkMessage> messages) {
            if (CollectionUtils.isEmpty(messages)) {
                return;
            }
            MixpanelEventSink.this.processBulkEventCreation(messages);
        }
    }
}

