/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.mixpanel;

import com.google.common.collect.Lists;
import com.google.inject.Singleton;
import io.castled.ObjectRegistry;
import io.castled.apps.ExternalAppConnector;
import io.castled.apps.ExternalAppType;
import io.castled.apps.connectors.mixpanel.MixpanelAppConfig;
import io.castled.apps.connectors.mixpanel.MixpanelAppSyncConfig;
import io.castled.apps.connectors.mixpanel.MixpanelDataSink;
import io.castled.apps.connectors.mixpanel.MixpanelObject;
import io.castled.apps.connectors.mixpanel.MixpanelObjectFields;
import io.castled.apps.models.ExternalAppSchema;
import io.castled.apps.models.GenericSyncObject;
import io.castled.apps.models.MappingGroupAggregator;
import io.castled.commons.models.AppSyncMode;
import io.castled.forms.dtos.FormFieldOption;
import io.castled.mapping.FixedGroupAppField;
import io.castled.mapping.PrimaryKeyGroupField;
import io.castled.mapping.QuestionnaireGroupField;
import io.castled.schema.mapping.MappingGroup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

@Singleton
public class MixpanelAppConnector
implements ExternalAppConnector<MixpanelAppConfig, MixpanelDataSink, MixpanelAppSyncConfig> {
    @Override
    public List<FormFieldOption> getAllObjects(MixpanelAppConfig mixpanelAppConfig, MixpanelAppSyncConfig mixpanelAppSyncConfig) {
        return Arrays.stream(MixpanelObject.values()).map(mixpanelObject -> new FormFieldOption((Object)new GenericSyncObject(mixpanelObject.getName(), ExternalAppType.MIXPANEL), mixpanelObject.getName())).collect(Collectors.toList());
    }

    @Override
    public MixpanelDataSink getDataSink() {
        return (MixpanelDataSink)ObjectRegistry.getInstance(MixpanelDataSink.class);
    }

    @Override
    public ExternalAppSchema getSchema(MixpanelAppConfig config, MixpanelAppSyncConfig mixpanelAppSyncConfig) {
        return new ExternalAppSchema(null);
    }

    @Override
    public List<AppSyncMode> getSyncModes(MixpanelAppConfig config, MixpanelAppSyncConfig mixpanelAppSyncConfig) {
        String object = mixpanelAppSyncConfig.getObject().getObjectName();
        if (MixpanelObject.EVENT.getName().equalsIgnoreCase(object)) {
            return Lists.newArrayList((Object[])new AppSyncMode[]{AppSyncMode.INSERT});
        }
        if (MixpanelObject.USER_PROFILE.getName().equalsIgnoreCase(object) || MixpanelObject.GROUP_PROFILE.getName().equalsIgnoreCase(object)) {
            return Lists.newArrayList((Object[])new AppSyncMode[]{AppSyncMode.UPSERT});
        }
        return Lists.newArrayList((Object[])new AppSyncMode[]{AppSyncMode.INSERT, AppSyncMode.UPSERT, AppSyncMode.UPDATE});
    }

    @Override
    public Class<MixpanelAppSyncConfig> getMappingConfigType() {
        return MixpanelAppSyncConfig.class;
    }

    @Override
    public Class<MixpanelAppConfig> getAppConfigType() {
        return MixpanelAppConfig.class;
    }

    @Override
    public List<MappingGroup> getMappingGroups(MixpanelAppConfig config, MixpanelAppSyncConfig mixpanelAppSyncConfig) {
        String object = mixpanelAppSyncConfig.getObject().getObjectName();
        if (MixpanelObject.EVENT.getName().equalsIgnoreCase(object)) {
            return this.getMappingGroupsForEventObject(config, mixpanelAppSyncConfig);
        }
        if (MixpanelObject.USER_PROFILE.getName().equalsIgnoreCase(object)) {
            return this.getMappingGroupsForUserProfileObject(config, mixpanelAppSyncConfig);
        }
        if (MixpanelObject.GROUP_PROFILE.getName().equalsIgnoreCase(object)) {
            return this.getMappingGroupsForGroupProfileObject(config, mixpanelAppSyncConfig);
        }
        return null;
    }

    private List<MappingGroup> getMappingGroupsForGroupProfileObject(MixpanelAppConfig config, MixpanelAppSyncConfig mixpanelAppSyncConfig) {
        ArrayList primaryKeyGroupFields = Lists.newArrayList();
        primaryKeyGroupFields.add(PrimaryKeyGroupField.builder().name(MixpanelObjectFields.GROUP_PROFILE_FIELDS.GROUP_ID.getFieldName()).displayName(MixpanelObjectFields.GROUP_PROFILE_FIELDS.GROUP_ID.getFieldTitle()).build());
        MappingGroupAggregator.Builder builder = MappingGroupAggregator.builder();
        return builder.addPrimaryKeyFields(primaryKeyGroupFields).addElasticAppFields(false, false).build().getMappingGroups();
    }

    private List<MappingGroup> getMappingGroupsForUserProfileObject(MixpanelAppConfig config, MixpanelAppSyncConfig mixpanelAppSyncConfig) {
        ArrayList primaryKeyGroupFields = Lists.newArrayList();
        primaryKeyGroupFields.add(PrimaryKeyGroupField.builder().name(MixpanelObjectFields.USER_PROFILE_FIELDS.DISTINCT_ID.getFieldName()).displayName(MixpanelObjectFields.USER_PROFILE_FIELDS.DISTINCT_ID.getFieldTitle()).build());
        ArrayList fixedGroupAppFields = Lists.newArrayList();
        fixedGroupAppFields.add(FixedGroupAppField.builder().name(MixpanelObjectFields.USER_PROFILE_FIELDS.FIRST_NAME.getFieldName()).displayName(MixpanelObjectFields.USER_PROFILE_FIELDS.FIRST_NAME.getFieldTitle()).optional(true).build());
        fixedGroupAppFields.add(FixedGroupAppField.builder().name(MixpanelObjectFields.USER_PROFILE_FIELDS.LAST_NAME.getFieldName()).displayName(MixpanelObjectFields.USER_PROFILE_FIELDS.LAST_NAME.getFieldTitle()).optional(true).build());
        fixedGroupAppFields.add(FixedGroupAppField.builder().name(MixpanelObjectFields.USER_PROFILE_FIELDS.EMAIL.getFieldName()).displayName(MixpanelObjectFields.USER_PROFILE_FIELDS.EMAIL.getFieldTitle()).optional(false).build());
        MappingGroupAggregator.Builder builder = MappingGroupAggregator.builder();
        return builder.addPrimaryKeyFields(primaryKeyGroupFields).addFixedAppFields(fixedGroupAppFields).addElasticAppFields(false, false).build().getMappingGroups();
    }

    private List<MappingGroup> getMappingGroupsForEventObject(MixpanelAppConfig config, MixpanelAppSyncConfig mixpanelAppSyncConfig) {
        ArrayList questionnaireGroupFields = Lists.newArrayList();
        questionnaireGroupFields.add(QuestionnaireGroupField.builder().title("Column identifying the event being synced").description("This field will be used at the destination to uniquely identify the event being synced").name(MixpanelObjectFields.EVENT_FIELDS.INSERT_ID.getFieldName()).optional(false).build());
        questionnaireGroupFields.add(QuestionnaireGroupField.builder().title("Column identifying the user associated with the event").description("This field will be used to uniquely identify the user associated with the event").name(MixpanelObjectFields.EVENT_FIELDS.DISTINCT_ID.getFieldName()).optional(false).build());
        questionnaireGroupFields.add(QuestionnaireGroupField.builder().title("Column identifying Event Timestamp").description("Column identifying Event Timestamp").name(MixpanelObjectFields.EVENT_FIELDS.EVENT_TIMESTAMP.getFieldName()).optional(true).build());
        MappingGroupAggregator.Builder builder = MappingGroupAggregator.builder();
        return builder.addQuestionnaireFields(questionnaireGroupFields).addElasticAppFields(false, false).build().getMappingGroups();
    }
}

