/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.marketo;

import com.google.common.collect.Maps;
import io.castled.apps.connectors.marketo.MarketoObject;
import io.castled.apps.connectors.marketo.dtos.GenericAttribute;
import io.castled.commons.models.AppSyncMode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ObjectAttributesContainer {
    private final List<GenericAttribute> attributes;
    private final List<String> dedupeKeys;
    private final String idKey;
    private final MarketoObject object;

    public List<GenericAttribute> getAttributes(AppSyncMode syncMode) {
        if (syncMode == AppSyncMode.UPDATE) {
            return this.attributes;
        }
        Predicate<GenericAttribute> isValidAttr = attr -> this.object == MarketoObject.LEADS && !attr.getRest().getName().equals(this.idKey) || this.object != MarketoObject.LEADS && !attr.getName().equals(this.idKey);
        return this.attributes.stream().filter(isValidAttr).collect(Collectors.toList());
    }

    public List<String> getPkEligibles(AppSyncMode syncMode) {
        HashMap nameMap = Maps.newHashMap();
        for (GenericAttribute attr : this.attributes) {
            if (this.object == MarketoObject.LEADS) {
                nameMap.put(attr.getRest().getName(), attr.getDisplayName());
                continue;
            }
            nameMap.put(attr.getName(), attr.getDisplayName());
        }
        List<String> dedupeKeyDisplayNames = this.dedupeKeys.stream().map(nameMap::get).collect(Collectors.toList());
        String idDisplayName = (String)nameMap.get(this.idKey);
        if (syncMode == AppSyncMode.UPDATE) {
            dedupeKeyDisplayNames.add(idDisplayName);
        }
        return dedupeKeyDisplayNames;
    }

    public Map<String, String> getDedupeAttrFieldMap() {
        HashMap attrFieldMap = Maps.newHashMap();
        attrFieldMap.put(this.idKey, "idField");
        this.dedupeKeys.stream().forEach(dedupeKey -> attrFieldMap.put(dedupeKey, "dedupeFields"));
        return attrFieldMap;
    }

    public ObjectAttributesContainer(List<GenericAttribute> attributes, List<String> dedupeKeys, String idKey, MarketoObject object) {
        this.attributes = attributes;
        this.dedupeKeys = dedupeKeys;
        this.idKey = idKey;
        this.object = object;
    }
}

