/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.marketo;

import io.castled.exceptions.CastledRuntimeException;
import java.util.Arrays;

public enum MarketoObject {
    LEADS("leads"),
    COMPANIES("companies"),
    OPPORTUNITIES("opportunities");

    private final String name;

    private MarketoObject(String name) {
        this.name = name;
    }

    public static MarketoObject getObjectByName(String name) {
        return Arrays.stream(MarketoObject.values()).filter(marketoObject -> marketoObject.getName().equals(name)).findFirst().orElseThrow(() -> new CastledRuntimeException(String.format("Invalid object name %s", name)));
    }

    public String getName() {
        return this.name;
    }
}

