/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.marketo;

import io.castled.apps.BufferedObjectSink;
import io.castled.apps.DataSink;
import io.castled.apps.connectors.marketo.MarketoAppSyncConfig;
import io.castled.apps.connectors.marketo.MarketoGenericObjectSink;
import io.castled.apps.connectors.marketo.MarketoLeadSink;
import io.castled.apps.connectors.marketo.MarketoObject;
import io.castled.apps.models.DataSinkRequest;
import io.castled.commons.models.AppSyncStats;
import io.castled.commons.models.DataSinkMessage;
import io.castled.exceptions.CastledRuntimeException;

public class MarketoDataSink
implements DataSink {
    private MarketoGenericObjectSink genericObjectSink = null;
    private MarketoLeadSink leadSink = null;

    @Override
    public void syncRecords(DataSinkRequest dataSinkRequest) throws Exception {
        DataSinkMessage msg;
        BufferedObjectSink objectSink;
        MarketoObject marketoObject = MarketoObject.getObjectByName(((MarketoAppSyncConfig)dataSinkRequest.getAppSyncConfig()).getObject().getObjectName());
        switch (marketoObject) {
            case LEADS: {
                this.leadSink = new MarketoLeadSink(dataSinkRequest);
                objectSink = this.leadSink;
                break;
            }
            case COMPANIES: 
            case OPPORTUNITIES: {
                this.genericObjectSink = new MarketoGenericObjectSink(dataSinkRequest);
                objectSink = this.genericObjectSink;
                break;
            }
            default: {
                throw new CastledRuntimeException(String.format("Invalid object type %s!", marketoObject.getName()));
            }
        }
        while ((msg = dataSinkRequest.getMessageInputStream().readMessage()) != null) {
            objectSink.writeRecord(msg);
        }
        objectSink.flushRecords();
    }

    @Override
    public AppSyncStats getSyncStats() {
        if (this.leadSink != null) {
            return this.leadSink.getSyncStats();
        }
        if (this.genericObjectSink != null) {
            return this.genericObjectSink.getSyncStats();
        }
        return new AppSyncStats(0L, 0L, 0L);
    }
}

