/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.mailchimp.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import io.castled.ObjectRegistry;
import io.castled.apps.connectors.mailchimp.MailchimpAccessConfig;
import io.castled.apps.connectors.mailchimp.client.dtos.Audience;
import io.castled.apps.connectors.mailchimp.client.dtos.AudienceListResponse;
import io.castled.apps.connectors.mailchimp.client.dtos.BatchOperation;
import io.castled.apps.connectors.mailchimp.client.dtos.BatchOperationStatus;
import io.castled.apps.connectors.mailchimp.client.dtos.BatchOperationsRequest;
import io.castled.apps.connectors.mailchimp.client.dtos.BatchOperationsResponse;
import io.castled.apps.connectors.mailchimp.client.dtos.MailchimpMember;
import io.castled.apps.connectors.mailchimp.client.models.MailchimpOperationError;
import io.castled.apps.connectors.mailchimp.client.models.MemberAndError;
import io.castled.exceptions.CastledRuntimeException;
import io.castled.oauth.OAuthDAO;
import io.castled.utils.JsonUtils;
import io.castled.utils.ThreadUtils;
import io.castled.utils.TimeUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.IOUtils;
import org.jdbi.v3.core.Jdbi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailchimpRestClient {
    private static final Logger log = LoggerFactory.getLogger(MailchimpRestClient.class);
    private static final String API_VERSION = "3.0";
    private final MailchimpAccessConfig mailchimpAccessConfig;
    private final Client client;

    public MailchimpRestClient(Long oauthToken) {
        this.mailchimpAccessConfig = (MailchimpAccessConfig)((OAuthDAO)((Jdbi)ObjectRegistry.getInstance(Jdbi.class)).onDemand(OAuthDAO.class)).getOAuthDetails(oauthToken).getAccessConfig();
        this.client = (Client)ObjectRegistry.getInstance(Client.class);
    }

    public static String getErrorResponse(InputStream responseStream) throws IOException {
        try (TarArchiveInputStream tarArchiveInputStream = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream(responseStream));){
            TarArchiveEntry archiveEntry = null;
            while ((archiveEntry = tarArchiveInputStream.getNextTarEntry()) != null) {
                if (!archiveEntry.getName().contains(".json") || !tarArchiveInputStream.canReadEntryData((ArchiveEntry)archiveEntry)) continue;
                String string = IOUtils.toString((InputStream)tarArchiveInputStream, (Charset)StandardCharsets.UTF_8);
                return string;
            }
            String string = null;
            return string;
        }
    }

    public List<Audience> getAllAudiences() {
        return ((AudienceListResponse)this.client.target(String.format("%s/%s/lists", this.mailchimpAccessConfig.getApiEndPoint(), API_VERSION)).request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + this.mailchimpAccessConfig.getAccessToken())).get(AudienceListResponse.class)).getLists();
    }

    public List<MemberAndError> upsertMembers(String audienceId, List<MailchimpMember> members) {
        try {
            BatchOperationsResponse batchOperationsResponse = this.createAudience(audienceId, members);
            ThreadUtils.interruptIgnoredSleep((long)TimeUtils.secondsToMillis((long)5L));
            while (batchOperationsResponse.getStatus() != BatchOperationStatus.finished) {
                batchOperationsResponse = this.getBatchStatus(batchOperationsResponse.getId());
                ThreadUtils.interruptIgnoredSleep((long)TimeUtils.secondsToMillis((long)2L));
            }
            String errorJson = MailchimpRestClient.getErrorResponse((InputStream)this.client.target(batchOperationsResponse.getResponseBodyUrl()).request(new String[]{"application/octet-stream"}).get(InputStream.class));
            List operationErrors = (List)JsonUtils.jsonStringToTypeReference((String)errorJson, (TypeReference)new TypeReference<List<MailchimpOperationError>>(){});
            return operationErrors.stream().filter(operationError -> operationError.getStatusCode() > 299).map(operationError -> new MemberAndError((MailchimpMember)members.get(Integer.parseInt(operationError.getOperationId())), (MailchimpOperationError)operationError)).collect(Collectors.toList());
        }
        catch (IOException e) {
            log.error(String.format("Upsert audience members failed for audience %s", audienceId), (Throwable)e);
            throw new CastledRuntimeException((Throwable)e);
        }
    }

    private BatchOperationsResponse getBatchStatus(String batchId) {
        return (BatchOperationsResponse)this.client.target(String.format("%s/%s/batches/%s", this.mailchimpAccessConfig.getApiEndPoint(), API_VERSION, batchId)).request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + this.mailchimpAccessConfig.getAccessToken())).get(BatchOperationsResponse.class);
    }

    private BatchOperationsResponse createAudience(String audienceId, List<MailchimpMember> members) {
        ArrayList batchOperations = Lists.newArrayList();
        long operationId = 0L;
        for (MailchimpMember mailchimpMember : members) {
            batchOperations.add(this.buildAudienceOperation(audienceId, operationId, mailchimpMember));
            ++operationId;
        }
        return (BatchOperationsResponse)this.client.target(String.format("%s/%s/batches", this.mailchimpAccessConfig.getApiEndPoint(), API_VERSION)).request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + this.mailchimpAccessConfig.getAccessToken())).post(Entity.json((Object)new BatchOperationsRequest(batchOperations)), BatchOperationsResponse.class);
    }

    private BatchOperation buildAudienceOperation(String audienceId, long operationId, MailchimpMember mailchimpMember) {
        String subscriberHash = DigestUtils.md5Hex((String)mailchimpMember.getEmailAddress()).toUpperCase();
        String path = String.format("/lists/%s/members/%s", audienceId, subscriberHash);
        String audienceBody = JsonUtils.objectToString((Object)mailchimpMember);
        return BatchOperation.builder().operationId(String.valueOf(operationId)).method("PUT").body(audienceBody).path(path).build();
    }
}

