/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.kafka;

import com.google.common.collect.Lists;
import io.castled.ObjectRegistry;
import io.castled.apps.ExternalAppConnector;
import io.castled.apps.connectors.kafka.KafkaAppConfig;
import io.castled.apps.connectors.kafka.KafkaAppSyncConfig;
import io.castled.apps.connectors.kafka.KafkaDataSink;
import io.castled.apps.models.ExternalAppSchema;
import io.castled.apps.models.MappingGroupAggregator;
import io.castled.commons.models.AppSyncMode;
import io.castled.exceptions.CastledRuntimeException;
import io.castled.exceptions.connect.InvalidConfigException;
import io.castled.forms.dtos.FormFieldOption;
import io.castled.schema.mapping.MappingGroup;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.common.KafkaException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class KafkaAppConnector
implements ExternalAppConnector<KafkaAppConfig, KafkaDataSink, KafkaAppSyncConfig> {
    private static final Logger log = LoggerFactory.getLogger(KafkaAppConnector.class);

    @Override
    public List<FormFieldOption> getAllObjects(KafkaAppConfig config, KafkaAppSyncConfig mappingConfig) {
        List<FormFieldOption> list;
        block8: {
            Properties properties = new Properties();
            properties.put("bootstrap.servers", config.getBootstrapServers());
            AdminClient adminClient = KafkaAdminClient.create((Properties)properties);
            try {
                list = ((Set)adminClient.listTopics().names().get()).stream().map(topic -> new FormFieldOption(topic, topic)).collect(Collectors.toList());
                if (adminClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (adminClient != null) {
                        try {
                            adminClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InterruptedException | ExecutionException e) {
                    log.error("Topics list failed for kafka", (Throwable)e);
                    throw new CastledRuntimeException((Throwable)e);
                }
            }
            adminClient.close();
        }
        return list;
    }

    @Override
    public void validateAppConfig(KafkaAppConfig kafkaAppConfig) throws InvalidConfigException {
        Properties properties = new Properties();
        properties.put("bootstrap.servers", kafkaAppConfig.getBootstrapServers());
        try {
            AdminClient ignored = KafkaAdminClient.create((Properties)properties);
            if (ignored != null) {
                ignored.close();
            }
        }
        catch (KafkaException e) {
            String rootCause = ExceptionUtils.getRootCauseMessage((Throwable)e);
            throw new InvalidConfigException(rootCause);
        }
    }

    @Override
    public KafkaDataSink getDataSink() {
        return (KafkaDataSink)ObjectRegistry.getInstance(KafkaDataSink.class);
    }

    @Override
    public ExternalAppSchema getSchema(KafkaAppConfig config, KafkaAppSyncConfig kafkaAppSyncConfig) {
        return new ExternalAppSchema(null);
    }

    @Override
    public Class<KafkaAppSyncConfig> getMappingConfigType() {
        return KafkaAppSyncConfig.class;
    }

    @Override
    public Class<KafkaAppConfig> getAppConfigType() {
        return KafkaAppConfig.class;
    }

    @Override
    public List<AppSyncMode> getSyncModes(KafkaAppConfig kafkaAppConfig, KafkaAppSyncConfig kafkaAppSyncConfig) {
        return Lists.newArrayList((Object[])new AppSyncMode[]{AppSyncMode.INSERT});
    }

    @Override
    public List<MappingGroup> getMappingGroups(KafkaAppConfig config, KafkaAppSyncConfig kafkaAppSyncConfig) {
        MappingGroupAggregator.Builder builder = MappingGroupAggregator.builder();
        return builder.addElasticAppFields(true, false).build().getMappingGroups();
    }
}

