/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.intercom.client.dtos;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import java.util.Optional;

@JsonNaming(value=PropertyNamingStrategy.SnakeCaseStrategy.class)
@JsonIgnoreProperties(ignoreUnknown=true)
public class PaginationObject {
    private int page;
    private int perPage;
    private int totalPages;
    private PaginationOffset next;

    public String getNextOffset() {
        return Optional.ofNullable(this.next).map(PaginationOffset::getStartingAfter).orElse(null);
    }

    public int getPage() {
        return this.page;
    }

    public int getPerPage() {
        return this.perPage;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public PaginationOffset getNext() {
        return this.next;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public void setPerPage(int perPage) {
        this.perPage = perPage;
    }

    public void setTotalPages(int totalPages) {
        this.totalPages = totalPages;
    }

    public void setNext(PaginationOffset next) {
        this.next = next;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaginationObject)) {
            return false;
        }
        PaginationObject other = (PaginationObject)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPage() != other.getPage()) {
            return false;
        }
        if (this.getPerPage() != other.getPerPage()) {
            return false;
        }
        if (this.getTotalPages() != other.getTotalPages()) {
            return false;
        }
        PaginationOffset this$next = this.getNext();
        PaginationOffset other$next = other.getNext();
        return !(this$next == null ? other$next != null : !((Object)this$next).equals(other$next));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PaginationObject;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPage();
        result = result * 59 + this.getPerPage();
        result = result * 59 + this.getTotalPages();
        PaginationOffset $next = this.getNext();
        result = result * 59 + ($next == null ? 43 : ((Object)$next).hashCode());
        return result;
    }

    public String toString() {
        return "PaginationObject(page=" + this.getPage() + ", perPage=" + this.getPerPage() + ", totalPages=" + this.getTotalPages() + ", next=" + this.getNext() + ")";
    }

    @JsonNaming(value=PropertyNamingStrategy.SnakeCaseStrategy.class)
    private static class PaginationOffset {
        private String startingAfter;

        public String getStartingAfter() {
            return this.startingAfter;
        }

        public void setStartingAfter(String startingAfter) {
            this.startingAfter = startingAfter;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PaginationOffset)) {
                return false;
            }
            PaginationOffset other = (PaginationOffset)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$startingAfter = this.getStartingAfter();
            String other$startingAfter = other.getStartingAfter();
            return !(this$startingAfter == null ? other$startingAfter != null : !this$startingAfter.equals(other$startingAfter));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PaginationOffset;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $startingAfter = this.getStartingAfter();
            result = result * 59 + ($startingAfter == null ? 43 : $startingAfter.hashCode());
            return result;
        }

        public String toString() {
            return "PaginationObject.PaginationOffset(startingAfter=" + this.getStartingAfter() + ")";
        }
    }
}

