/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.intercom;

import io.castled.exceptions.CastledRuntimeException;
import java.util.Arrays;

public enum IntercomObject {
    LEAD("Lead"),
    USER("User"),
    COMPANY("Company");

    private final String name;

    private IntercomObject(String name) {
        this.name = name;
    }

    public static IntercomObject getObjectByName(String name) {
        return Arrays.stream(IntercomObject.values()).filter(intercomObject -> intercomObject.getName().equals(name)).findFirst().orElseThrow(() -> new CastledRuntimeException(String.format("Invalid object name %s", name)));
    }

    public String getName() {
        return this.name;
    }
}

