/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.intercom;

import com.google.inject.Inject;
import io.castled.apps.DataSink;
import io.castled.apps.connectors.intercom.IntercomAppConfig;
import io.castled.apps.connectors.intercom.IntercomAppSyncConfig;
import io.castled.apps.connectors.intercom.IntercomObject;
import io.castled.apps.connectors.intercom.IntercomObjectSink;
import io.castled.apps.models.DataSinkRequest;
import io.castled.apps.models.GenericSyncObject;
import io.castled.apps.models.PrimaryKeyIdMapper;
import io.castled.apps.syncconfigs.AppSyncConfig;
import io.castled.commons.models.AppSyncMode;
import io.castled.commons.models.AppSyncStats;
import io.castled.commons.models.DataSinkMessage;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class IntercomDataSink
implements DataSink {
    private final Map<IntercomObject, IntercomObjectSink> intercomObjectSinks;
    private long skippedRecords = 0L;
    private volatile IntercomObjectSink intercomObjectSink;

    @Inject
    public IntercomDataSink(Map<IntercomObject, IntercomObjectSink> intercomObjectSinks) {
        this.intercomObjectSinks = intercomObjectSinks;
    }

    @Override
    public void syncRecords(DataSinkRequest dataSinkRequest) throws Exception {
        DataSinkMessage message;
        GenericSyncObject intercomSyncObject = ((IntercomAppSyncConfig)dataSinkRequest.getAppSyncConfig()).getObject();
        IntercomObject intercomObject = IntercomObject.getObjectByName(intercomSyncObject.getObjectName());
        this.intercomObjectSink = this.intercomObjectSinks.get((Object)intercomObject).initialize(intercomObject, dataSinkRequest.getAppSyncConfig(), (IntercomAppConfig)dataSinkRequest.getExternalApp().getConfig(), dataSinkRequest.getErrorOutputStream(), dataSinkRequest.getPrimaryKeys());
        while ((message = dataSinkRequest.getMessageInputStream().readMessage()) != null) {
            if (this.writeRecord(message, dataSinkRequest.getAppSyncConfig(), this.intercomObjectSink, dataSinkRequest.getPrimaryKeys())) continue;
            ++this.skippedRecords;
        }
        this.intercomObjectSink.flushRecords();
    }

    @Override
    public AppSyncStats getSyncStats() {
        return Optional.ofNullable(this.intercomObjectSink).map(IntercomObjectSink::getSyncStats).map(statsRef -> new AppSyncStats(statsRef.getRecordsProcessed(), statsRef.getOffset(), this.skippedRecords)).orElse(new AppSyncStats(0L, 0L, 0L));
    }

    private boolean writeRecord(DataSinkMessage message, AppSyncConfig appSyncConfig, IntercomObjectSink intercomObjectSink, List<String> primaryKeys) {
        List<Object> primaryKeyValues = primaryKeys.stream().map(pk -> message.getRecord().getValue(pk)).collect(Collectors.toList());
        PrimaryKeyIdMapper primaryKeyIdMapper = intercomObjectSink.getPrimaryKeyIdMapper();
        Object objectId = primaryKeyIdMapper.getObjectId(primaryKeyValues);
        IntercomAppSyncConfig intercomSyncConfig = (IntercomAppSyncConfig)appSyncConfig;
        if (intercomSyncConfig.getMode() == AppSyncMode.UPDATE && objectId == null) {
            return false;
        }
        if (objectId == null) {
            intercomObjectSink.createObject(message);
        } else {
            intercomObjectSink.updateObject(objectId, message);
        }
        return true;
    }
}

