/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.intercom;

import com.google.common.collect.Lists;
import com.google.inject.Singleton;
import io.castled.ObjectRegistry;
import io.castled.apps.ExternalAppConnector;
import io.castled.apps.ExternalAppType;
import io.castled.apps.connectors.intercom.IntercomAppConfig;
import io.castled.apps.connectors.intercom.IntercomAppSyncConfig;
import io.castled.apps.connectors.intercom.IntercomDataSink;
import io.castled.apps.connectors.intercom.IntercomObject;
import io.castled.apps.connectors.intercom.IntercomUtils;
import io.castled.apps.connectors.intercom.client.IntercomRestClient;
import io.castled.apps.connectors.intercom.client.dtos.DataAttribute;
import io.castled.apps.connectors.intercom.client.models.IntercomModel;
import io.castled.apps.models.ExternalAppSchema;
import io.castled.apps.models.GenericSyncObject;
import io.castled.apps.models.MappingGroupAggregator;
import io.castled.commons.models.AppSyncMode;
import io.castled.exceptions.CastledRuntimeException;
import io.castled.forms.dtos.FormFieldOption;
import io.castled.mapping.FixedGroupAppField;
import io.castled.mapping.PrimaryKeyGroupField;
import io.castled.mapping.QuestionnaireGroupField;
import io.castled.schema.mapping.MappingGroup;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

@Singleton
public class IntercomAppConnector
implements ExternalAppConnector<IntercomAppConfig, IntercomDataSink, IntercomAppSyncConfig> {
    @Override
    public List<FormFieldOption> getAllObjects(IntercomAppConfig config, IntercomAppSyncConfig mappingConfig) {
        return Arrays.stream(IntercomObject.values()).map(intercomObject -> new FormFieldOption((Object)new GenericSyncObject(intercomObject.getName(), ExternalAppType.INTERCOM), intercomObject.getName())).collect(Collectors.toList());
    }

    @Override
    public IntercomDataSink getDataSink() {
        return (IntercomDataSink)ObjectRegistry.getInstance(IntercomDataSink.class);
    }

    @Override
    public ExternalAppSchema getSchema(IntercomAppConfig config, IntercomAppSyncConfig mappingConfig) {
        IntercomRestClient intercomRestClient = new IntercomRestClient(config.getAccessToken());
        IntercomObject intercomObject = IntercomObject.getObjectByName(mappingConfig.getObject().getObjectName());
        IntercomModel intercomModel = IntercomUtils.getIntercomModel(intercomObject);
        List<DataAttribute> dataAttributes = intercomRestClient.listAttributes(intercomModel);
        return new ExternalAppSchema(IntercomUtils.getSchema(intercomObject, dataAttributes));
    }

    @Override
    public Class<IntercomAppSyncConfig> getMappingConfigType() {
        return IntercomAppSyncConfig.class;
    }

    public List<String> getPrimaryKeyEligibles(IntercomModel intercomModel) {
        switch (intercomModel) {
            case CONTACT: {
                return Lists.newArrayList((Object[])new String[]{"email", "external_id"});
            }
            case COMPANY: {
                return Lists.newArrayList((Object[])new String[]{"company_id"});
            }
        }
        throw new CastledRuntimeException(String.format("Model %s not supported", new Object[]{intercomModel}));
    }

    @Override
    public List<AppSyncMode> getSyncModes(IntercomAppConfig config, IntercomAppSyncConfig mappingConfig) {
        return Lists.newArrayList((Object[])new AppSyncMode[]{AppSyncMode.UPDATE, AppSyncMode.UPSERT});
    }

    private List<QuestionnaireGroupField> getQuestionnaireFields(IntercomAppSyncConfig intercomAppSyncConfig) {
        if (!intercomAppSyncConfig.isAssociateCompany()) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Object[])new QuestionnaireGroupField[]{new QuestionnaireGroupField("Which source column contains the Company Id to associate contacts to companies", null, false, "company_id")});
    }

    @Override
    public List<MappingGroup> getMappingGroups(IntercomAppConfig intercomAppConfig, IntercomAppSyncConfig intercomAppSyncConfig) {
        IntercomRestClient intercomRestClient = new IntercomRestClient(intercomAppConfig.getAccessToken());
        IntercomObject intercomObject = IntercomObject.getObjectByName(intercomAppSyncConfig.getObject().getObjectName());
        IntercomModel intercomModel = IntercomUtils.getIntercomModel(intercomObject);
        List<DataAttribute> dataAttributes = intercomRestClient.listAttributes(intercomModel);
        return MappingGroupAggregator.builder().addQuestionnaireFields(this.getQuestionnaireFields(intercomAppSyncConfig)).addPrimaryKeyFields(this.getPrimaryKeyGroupFields(intercomModel)).addFixedAppFields(this.getFixedGroupAppFields(intercomModel, dataAttributes)).build().getMappingGroups();
    }

    private List<PrimaryKeyGroupField> getPrimaryKeyGroupFields(IntercomModel intercomModel) {
        return this.getPrimaryKeyEligibles(intercomModel).stream().map(field -> new PrimaryKeyGroupField((String)field, (String)field, true)).collect(Collectors.toList());
    }

    private List<FixedGroupAppField> getFixedGroupAppFields(IntercomModel intercomModel, List<DataAttribute> dataAttributes) {
        if (intercomModel == IntercomModel.CONTACT) {
            return dataAttributes.stream().map(DataAttribute::getName).map(field -> new FixedGroupAppField((String)field, (String)field, true)).collect(Collectors.toList());
        }
        return dataAttributes.stream().map(DataAttribute::getName).filter(field -> !this.getPrimaryKeyEligibles(intercomModel).contains(field)).map(field -> new FixedGroupAppField((String)field, (String)field, true)).collect(Collectors.toList());
    }

    @Override
    public Class<IntercomAppConfig> getAppConfigType() {
        return IntercomAppConfig.class;
    }
}

