/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.hubspot.oauth;

import io.castled.ObjectRegistry;
import io.castled.apps.connectors.hubspot.HubspotAccessConfig;
import io.castled.apps.connectors.hubspot.client.HubspotAuthClient;
import io.castled.apps.connectors.hubspot.client.dtos.HubspotTokenResponse;
import io.castled.cache.OAuthCache;
import io.castled.oauth.AccessTokenRefresher;
import io.castled.oauth.OAuthClientConfig;
import io.castled.oauth.OAuthDAO;
import io.castled.oauth.OAuthDetails;
import io.castled.pubsub.MessagePublisher;
import io.castled.pubsub.registry.Message;
import io.castled.pubsub.registry.OAuthDetailsUpdatedMessage;
import org.jdbi.v3.core.Jdbi;

public class HubspotAccessTokenRefresher
implements AccessTokenRefresher<HubspotAccessConfig> {
    private final OAuthDAO oAuthDAO = (OAuthDAO)((Jdbi)ObjectRegistry.getInstance(Jdbi.class)).onDemand(OAuthDAO.class);
    private final HubspotAuthClient hubspotAuthClient = (HubspotAuthClient)ObjectRegistry.getInstance(HubspotAuthClient.class);
    private final OAuthClientConfig oAuthClientConfig;
    private final OAuthCache oAuthCache;
    private final MessagePublisher messagePublisher;

    public HubspotAccessTokenRefresher(OAuthClientConfig oAuthClientConfig) {
        this.oAuthClientConfig = oAuthClientConfig;
        this.oAuthCache = (OAuthCache)((Object)ObjectRegistry.getInstance(OAuthCache.class));
        this.messagePublisher = (MessagePublisher)ObjectRegistry.getInstance(MessagePublisher.class);
    }

    @Override
    public HubspotAccessConfig refreshAndPersistAccessConfig(Long oAuthToken) {
        OAuthDetails oAuthDetails = (OAuthDetails)this.oAuthCache.getValue(oAuthToken);
        HubspotTokenResponse hubspotTokenResponse = this.hubspotAuthClient.getTokenViaRefreshToken(oAuthDetails.getAccessConfig().getRefreshToken(), this.oAuthClientConfig.getClientId(), this.oAuthClientConfig.getClientSecret());
        HubspotAccessConfig hubspotAccessConfig = HubspotAccessConfig.builder().accessToken(hubspotTokenResponse.getAccessToken()).refreshToken(hubspotTokenResponse.getRefreshToken()).build();
        this.oAuthDAO.updateAccessConfig(oAuthToken, hubspotAccessConfig);
        this.messagePublisher.publishMessage((Message)new OAuthDetailsUpdatedMessage(oAuthToken));
        return hubspotAccessConfig;
    }
}

