/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.hubspot.client.dtos;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;

public enum HubspotType {
    STRING("string"),
    NUMBER("number"),
    DATE("date"),
    DATETIME("datetime"),
    ENUMERATION("enumeration"),
    BOOLEAN("bool"),
    PHONE_NUMBER("phone_number");

    private final String displayName;

    @JsonValue
    public String toJsonValue() {
        return this.displayName;
    }

    @JsonCreator
    public static HubspotType fromDisplayName(String displayName) {
        return Arrays.stream(HubspotType.values()).filter(v -> v.displayName.equals(displayName)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.valueOf(displayName)));
    }

    private HubspotType(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }
}

