/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.googlesheets;

import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.services.sheets.v4.Sheets;
import com.google.api.services.sheets.v4.model.Sheet;
import com.google.api.services.sheets.v4.model.Spreadsheet;
import com.google.inject.Singleton;
import io.castled.ObjectRegistry;
import io.castled.apps.ExternalAppConnector;
import io.castled.apps.connectors.googlesheets.GoogleSheetUtils;
import io.castled.apps.connectors.googlesheets.GoogleSheetsAppConfig;
import io.castled.apps.connectors.googlesheets.GoogleSheetsAppSyncConfig;
import io.castled.apps.connectors.googlesheets.GoogleSheetsDataSink;
import io.castled.apps.connectors.googlesheets.GoogleSheetsSyncObject;
import io.castled.apps.models.ExternalAppSchema;
import io.castled.apps.models.MappingGroupAggregator;
import io.castled.exceptions.CastledRuntimeException;
import io.castled.exceptions.connect.InvalidConfigException;
import io.castled.forms.dtos.FormFieldOption;
import io.castled.schema.mapping.MappingGroup;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class GoogleSheetsAppConnector
implements ExternalAppConnector<GoogleSheetsAppConfig, GoogleSheetsDataSink, GoogleSheetsAppSyncConfig> {
    private static final Logger log = LoggerFactory.getLogger(GoogleSheetsAppConnector.class);

    @Override
    public List<FormFieldOption> getAllObjects(GoogleSheetsAppConfig config, GoogleSheetsAppSyncConfig mappingConfig) {
        try {
            Sheets sheetsService = GoogleSheetUtils.getSheets(config.getServiceAccount());
            Spreadsheet spreadsheet = (Spreadsheet)sheetsService.spreadsheets().get(GoogleSheetUtils.getSpreadSheetId(config.getSpreadSheetId())).execute();
            return spreadsheet.getSheets().stream().map(Sheet::getProperties).map(sheetProperties -> new FormFieldOption((Object)new GoogleSheetsSyncObject(sheetProperties.getSheetId(), sheetProperties.getTitle()), sheetProperties.getTitle())).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error("Gsheets get objects failed for {}", (Object)config.getServiceAccount().getClientEmail(), (Object)e);
            throw new CastledRuntimeException((Throwable)e);
        }
    }

    @Override
    public void validateAppConfig(GoogleSheetsAppConfig appConfig) throws InvalidConfigException {
        try {
            if (!GoogleSheetUtils.validSpreadSheetUrl(appConfig.getSpreadSheetId())) {
                throw new InvalidConfigException("SpreadSheet Url should be in the format: https://docs.google.com/spreadsheets/[/u/1]/d/spreadsheetId/edit.*");
            }
            Sheets sheets = GoogleSheetUtils.getSheets(appConfig.getServiceAccount());
            sheets.spreadsheets().get(GoogleSheetUtils.getSpreadSheetId(appConfig.getSpreadSheetId())).execute();
        }
        catch (Exception e) {
            GoogleJsonResponseException gre;
            if (e instanceof GoogleJsonResponseException && (gre = (GoogleJsonResponseException)e).getStatusCode() == 403) {
                if (gre.getMessage().contains("Google Sheets API has not been used")) {
                    throw new InvalidConfigException("Google Sheets API needs to be enabled in Google Cloud Console");
                }
                throw new InvalidConfigException("Service account does not sufficient privileges to access the spreadsheet");
            }
            throw new InvalidConfigException(e.getMessage());
        }
    }

    @Override
    public List<MappingGroup> getMappingGroups(GoogleSheetsAppConfig config, GoogleSheetsAppSyncConfig googleSheetsAppSyncConfig) {
        return MappingGroupAggregator.builder().addElasticAppFields(null, "One or more needs to be marked as primary key", true, true).build().getMappingGroups();
    }

    @Override
    public GoogleSheetsDataSink getDataSink() {
        return (GoogleSheetsDataSink)ObjectRegistry.getInstance(GoogleSheetsDataSink.class);
    }

    @Override
    public ExternalAppSchema getSchema(GoogleSheetsAppConfig config, GoogleSheetsAppSyncConfig googleSheetsAppSyncConfig) {
        return new ExternalAppSchema(null);
    }

    @Override
    public Class<GoogleSheetsAppSyncConfig> getMappingConfigType() {
        return GoogleSheetsAppSyncConfig.class;
    }

    @Override
    public Class<GoogleSheetsAppConfig> getAppConfigType() {
        return GoogleSheetsAppConfig.class;
    }
}

