/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.googleads;

import io.castled.apps.DataSink;
import io.castled.apps.connectors.googleads.ConversionObjectSink;
import io.castled.apps.connectors.googleads.CustomerMatchObjectSink;
import io.castled.apps.connectors.googleads.GadsObjectSink;
import io.castled.apps.connectors.googleads.GoogleAdsAppConfig;
import io.castled.apps.connectors.googleads.GoogleAdsAppSyncConfig;
import io.castled.apps.models.DataSinkRequest;
import io.castled.commons.models.AppSyncStats;
import io.castled.commons.models.DataSinkMessage;
import io.castled.commons.streams.ErrorOutputStream;
import io.castled.exceptions.CastledRuntimeException;
import java.util.Optional;

public class GoogleAdsDataSink
implements DataSink {
    private GadsObjectSink gadsObjectSink;

    @Override
    public void syncRecords(DataSinkRequest dataSinkRequest) throws Exception {
        DataSinkMessage message;
        this.gadsObjectSink = this.getObjectSink((GoogleAdsAppSyncConfig)dataSinkRequest.getAppSyncConfig(), (GoogleAdsAppConfig)dataSinkRequest.getExternalApp().getConfig(), dataSinkRequest.getErrorOutputStream());
        while ((message = dataSinkRequest.getMessageInputStream().readMessage()) != null) {
            this.gadsObjectSink.writeRecord(message);
        }
        this.gadsObjectSink.flushRecords();
    }

    private GadsObjectSink getObjectSink(GoogleAdsAppSyncConfig mappingConfig, GoogleAdsAppConfig googleAdsAppConfig, ErrorOutputStream errorOutputStream) {
        switch (mappingConfig.getObjectType()) {
            case CUSTOMER_MATCH: {
                return new CustomerMatchObjectSink(mappingConfig, googleAdsAppConfig, errorOutputStream);
            }
            case CLICK_CONVERSIONS: 
            case CALL_CONVERSIONS: {
                return new ConversionObjectSink(mappingConfig, googleAdsAppConfig, errorOutputStream);
            }
        }
        throw new CastledRuntimeException(String.format("Unhandled sync object type %s", new Object[]{mappingConfig.getObjectType()}));
    }

    @Override
    public AppSyncStats getSyncStats() {
        return Optional.ofNullable(this.gadsObjectSink).map(GadsObjectSink::getSyncStats).map(statsRef -> new AppSyncStats(statsRef.getRecordsProcessed(), statsRef.getOffset(), 0L)).orElse(new AppSyncStats(0L, 0L, 0L));
    }
}

