/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.googleads;

import io.castled.apps.connectors.googleads.CustomerMatchType;
import io.castled.apps.connectors.googleads.GAdsObjectType;
import io.castled.apps.connectors.googleads.GadsConversion;
import io.castled.apps.connectors.googleads.GadsCustomerMatch;
import io.castled.apps.syncconfigs.BaseAppSyncConfig;
import io.castled.forms.FormField;
import io.castled.forms.FormFieldSchema;
import io.castled.forms.FormFieldType;
import io.castled.forms.GroupActivator;
import io.castled.forms.GroupActivators;
import io.castled.forms.OptionsRef;
import io.castled.forms.OptionsRefType;

@GroupActivators(value={@GroupActivator(dependencies={"accountId"}, group="loginAccountId"), @GroupActivator(dependencies={"loginCustomerId"}, group="objectType"), @GroupActivator(dependencies={"objectType", "loginCustomerId"}, condition="objectType == 'CUSTOMER_MATCH'", group="customerMatchType"), @GroupActivator(dependencies={"customerMatchType, objectType"}, condition="objectType == 'CUSTOMER_MATCH' && customerMatchType != null", group="customerMatch"), @GroupActivator(dependencies={"objectType", "loginCustomerId"}, condition="objectType == 'CLICK_CONVERSIONS'", group="clickConversions"), @GroupActivator(dependencies={"objectType", "loginCustomerId"}, condition="objectType == 'CALL_CONVERSIONS'", group="callConversions"), @GroupActivator(dependencies={"objectType", "loginCustomerId"}, condition="objectType == 'CALL_CONVERSIONS' || objectType == 'CLICK_CONVERSIONS'", group="zoneId")})
public class GoogleAdsAppSyncConfig
extends BaseAppSyncConfig {
    @FormField(type=FormFieldType.DROP_DOWN, title="Customer Id", description="Google customer Id from the Google ads console eg: 788-9993-09993", optionsRef=@OptionsRef(value="Gads Account Id", type=OptionsRefType.DYNAMIC))
    private String accountId;
    @FormField(type=FormFieldType.HIDDEN, title="Auto Generated Login CustomerId", optionsRef=@OptionsRef(value="Gads Login Account Id", type=OptionsRefType.DYNAMIC), group="loginAccountId", loadingText="Fetching google ads resources...")
    private String loginCustomerId;
    @FormField(type=FormFieldType.RADIO_BOX, schema=FormFieldSchema.STRING, title="Select resource to sync the data", description="Google Ads resource to sync the data", group="objectType", optionsRef=@OptionsRef(value="Object", type=OptionsRefType.DYNAMIC))
    private GAdsObjectType objectType;
    @FormField(type=FormFieldType.RADIO_BOX, schema=FormFieldSchema.STRING, title="Customer Match Type", description="Customer Match Type", group="customerMatchType", optionsRef=@OptionsRef(value="CUSTOMER_MATCH_TYPE", type=OptionsRefType.STATIC))
    private CustomerMatchType customerMatchType;
    @FormField(type=FormFieldType.DROP_DOWN, schema=FormFieldSchema.OBJECT, title="Customer Match List Name", description="Customer Match list", group="customerMatch", optionsRef=@OptionsRef(value="gads_sub_resource", type=OptionsRefType.DYNAMIC))
    private GadsCustomerMatch customerMatch;
    @FormField(type=FormFieldType.DROP_DOWN, schema=FormFieldSchema.OBJECT, title="Click Conversion Name", group="clickConversions", optionsRef=@OptionsRef(value="gads_sub_resource", type=OptionsRefType.DYNAMIC))
    private GadsConversion clickConversion;
    @FormField(type=FormFieldType.DROP_DOWN, schema=FormFieldSchema.OBJECT, title="Call Conversion Name", group="callConversions", optionsRef=@OptionsRef(value="gads_sub_resource", type=OptionsRefType.DYNAMIC))
    private GadsConversion callConversion;
    @FormField(type=FormFieldType.DROP_DOWN, schema=FormFieldSchema.STRING, title="Conversion Time Zone", group="zoneId", optionsRef=@OptionsRef(value="ZONE_IDS", type=OptionsRefType.STATIC))
    private String zoneId;

    public String getAccountId() {
        return this.accountId;
    }

    public String getLoginCustomerId() {
        return this.loginCustomerId;
    }

    public GAdsObjectType getObjectType() {
        return this.objectType;
    }

    public CustomerMatchType getCustomerMatchType() {
        return this.customerMatchType;
    }

    public GadsCustomerMatch getCustomerMatch() {
        return this.customerMatch;
    }

    public GadsConversion getClickConversion() {
        return this.clickConversion;
    }

    public GadsConversion getCallConversion() {
        return this.callConversion;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public void setLoginCustomerId(String loginCustomerId) {
        this.loginCustomerId = loginCustomerId;
    }

    public void setObjectType(GAdsObjectType objectType) {
        this.objectType = objectType;
    }

    public void setCustomerMatchType(CustomerMatchType customerMatchType) {
        this.customerMatchType = customerMatchType;
    }

    public void setCustomerMatch(GadsCustomerMatch customerMatch) {
        this.customerMatch = customerMatch;
    }

    public void setClickConversion(GadsConversion clickConversion) {
        this.clickConversion = clickConversion;
    }

    public void setCallConversion(GadsConversion callConversion) {
        this.callConversion = callConversion;
    }

    public void setZoneId(String zoneId) {
        this.zoneId = zoneId;
    }
}

