/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.googleads;

import io.castled.oauth.OAuthAccessConfig;
import io.castled.oauth.OAuthServiceType;

public class GadsAccessConfig
extends OAuthAccessConfig {
    private String email;

    public GadsAccessConfig(String email, String accessToken, String refreshToken) {
        super(OAuthServiceType.GADS, accessToken, refreshToken);
        this.email = email;
    }

    public static GadsAccessConfigBuilder builder() {
        return new GadsAccessConfigBuilder();
    }

    public String getEmail() {
        return this.email;
    }

    public GadsAccessConfig() {
    }

    public static class GadsAccessConfigBuilder {
        private String email;
        private String accessToken;
        private String refreshToken;

        GadsAccessConfigBuilder() {
        }

        public GadsAccessConfigBuilder email(String email) {
            this.email = email;
            return this;
        }

        public GadsAccessConfigBuilder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public GadsAccessConfigBuilder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public GadsAccessConfig build() {
            return new GadsAccessConfig(this.email, this.accessToken, this.refreshToken);
        }

        public String toString() {
            return "GadsAccessConfig.GadsAccessConfigBuilder(email=" + this.email + ", accessToken=" + this.accessToken + ", refreshToken=" + this.refreshToken + ")";
        }
    }
}

