/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.fbcustomaudience;

import io.castled.ObjectRegistry;
import io.castled.apps.DataSink;
import io.castled.apps.connectors.fbcustomaudience.FbAccessConfig;
import io.castled.apps.connectors.fbcustomaudience.FbAppConfig;
import io.castled.apps.connectors.fbcustomaudience.FbCustomAudAppSyncConfig;
import io.castled.apps.connectors.fbcustomaudience.FbCustomAudienceCustomerSink;
import io.castled.apps.connectors.fbcustomaudience.FbTokenRefresher;
import io.castled.apps.models.DataSinkRequest;
import io.castled.commons.models.AppSyncStats;
import io.castled.commons.models.DataSinkMessage;
import io.castled.oauth.OAuthDetails;
import io.castled.services.OAuthService;
import java.time.Instant;
import java.util.Optional;

public class FbCustomAudDataSink
implements DataSink {
    private volatile FbCustomAudienceCustomerSink fbCustomAudienceCustomerSink;

    @Override
    public void syncRecords(DataSinkRequest dataSinkRequest) throws Exception {
        DataSinkMessage msg;
        this.renewAccessToken((FbAppConfig)dataSinkRequest.getExternalApp().getConfig());
        this.fbCustomAudienceCustomerSink = new FbCustomAudienceCustomerSink((FbAppConfig)dataSinkRequest.getExternalApp().getConfig(), (FbCustomAudAppSyncConfig)dataSinkRequest.getAppSyncConfig(), dataSinkRequest.getErrorOutputStream());
        while ((msg = dataSinkRequest.getMessageInputStream().readMessage()) != null) {
            this.fbCustomAudienceCustomerSink.writeRecord(msg);
        }
        this.fbCustomAudienceCustomerSink.flushRecords();
    }

    @Override
    public AppSyncStats getSyncStats() {
        return Optional.ofNullable(this.fbCustomAudienceCustomerSink).map(FbCustomAudienceCustomerSink::getSyncStats).orElse(new AppSyncStats(0L, 0L, 0L));
    }

    private void renewAccessToken(FbAppConfig appConfig) {
        OAuthDetails oAuthDetails = ((OAuthService)ObjectRegistry.getInstance(OAuthService.class)).getOAuthDetails(appConfig.getOAuthToken());
        FbAccessConfig accessConfig = (FbAccessConfig)oAuthDetails.getAccessConfig();
        long TOKEN_REFRESH_BUFFER_SECONDS = 864000L;
        if (accessConfig.getTokenEpochSecond() + accessConfig.getExpiresIn() - TOKEN_REFRESH_BUFFER_SECONDS < Instant.EPOCH.getEpochSecond()) {
            FbTokenRefresher fbTokenRefresher = new FbTokenRefresher(appConfig.getClientConfig());
            fbTokenRefresher.refreshAndPersistAccessConfig(appConfig.getOAuthToken());
        }
    }
}

