/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.fbconversion.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.castled.ObjectRegistry;
import io.castled.apps.connectors.fbconversion.FbConversionAppConfig;
import io.castled.apps.connectors.fbconversion.FbConversionStatus;
import io.castled.apps.connectors.fbconversion.FbConversionSyncConfig;
import io.castled.apps.connectors.fbconversion.client.dtos.ConversionEventErrorResponse;
import io.castled.apps.connectors.fbconversion.client.dtos.ConversionEventResponse;
import io.castled.exceptions.CastledRuntimeException;
import io.castled.utils.ResponseUtils;
import io.castled.utils.StringUtils;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;

public class FbConversionClient {
    private static final String API_ENDPOINT = "https://graph.facebook.com/v13.0";
    private final Client client = (Client)ObjectRegistry.getInstance(Client.class);
    private final FbConversionAppConfig appConfig;
    private final FbConversionSyncConfig appSyncConfig;

    public FbConversionClient(FbConversionAppConfig appConfig, FbConversionSyncConfig appSyncConfig) {
        this.appConfig = appConfig;
        this.appSyncConfig = appSyncConfig;
    }

    public FbConversionStatus sendConversionEvents(List<Map<String, Object>> data) {
        String pixelID = this.appConfig.getPixelId();
        ObjectMapper objMapper = new ObjectMapper();
        Form form = new Form();
        try {
            form.param("access_token", this.appConfig.getAccessToken());
            form.param("data", objMapper.writeValueAsString(data));
            if (!StringUtils.isEmpty((String)this.appSyncConfig.getTestEventCode())) {
                form.param("test_event_code", this.appSyncConfig.getTestEventCode());
            }
        }
        catch (JsonProcessingException e) {
            throw new CastledRuntimeException((Throwable)e);
        }
        Response response = this.client.target(String.format("%s/%s/events", API_ENDPOINT, pixelID)).request(new String[]{"application/json"}).post(Entity.form((Form)form));
        if (!ResponseUtils.is2xx((Response)response)) {
            ConversionEventErrorResponse error = (ConversionEventErrorResponse)response.readEntity(ConversionEventErrorResponse.class);
            if (error.getError().getCode() == 100) {
                return new FbConversionStatus(0L, error.getError().getErrorUserTitle(), error.getError().getErrorUserMsg());
            }
            throw new CastledRuntimeException(String.format("%s:%s", error.getError().getType(), error.getError().getMessage()));
        }
        ConversionEventResponse listResponse = (ConversionEventResponse)response.readEntity(ConversionEventResponse.class);
        return new FbConversionStatus(listResponse.getEventsReceived(), null, null);
    }
}

