/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.fbconversion;

import com.google.inject.Singleton;
import io.castled.forms.StaticOptionsFetcher;
import io.castled.forms.dtos.FormFieldOption;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

@Singleton
public class FbActionSourceOptionsFetcher
implements StaticOptionsFetcher {
    public List<FormFieldOption> getOptions() {
        List<FormFieldOption> formFieldOptions = Arrays.stream(ActionSources.values()).map(enumVal -> new FormFieldOption((Object)enumVal.getName(), enumVal.getName(), enumVal.getDescription())).collect(Collectors.toList());
        return formFieldOptions;
    }

    private static enum ActionSources {
        EMAIL("email", "Conversion happened over email"),
        WEBSITE("website", "Conversion was made on your website"),
        PHONE_CALL("phone_call", "Conversion was made over the phone"),
        CHAT("chat", "Conversion was made via a messaging app, SMS, or online messaging feature"),
        PHYSICAL_STORE("physical_store", "Conversion was made in person at your physical store"),
        SYSTEM_GENERATED("system_generated", "Conversion happened automatically, for example, a subscription renewal that\u2019s set to auto-pay each month"),
        OTHER("other", "Conversion happened in a way that is not listed");

        private String name;
        private String description;

        private ActionSources(String name, String description) {
            this.name = name;
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

