/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.activecampaign.client;

import io.castled.ObjectRegistry;
import io.castled.apps.connectors.activecampaign.constant.ActiveCampaignConstants;
import io.castled.apps.connectors.activecampaign.dto.BulkImportRequest;
import io.castled.apps.connectors.activecampaign.dto.BulkImportResponse;
import io.castled.apps.connectors.activecampaign.dto.BulkImportStatusInfoResponse;
import io.castled.apps.connectors.activecampaign.dto.Contact;
import io.castled.apps.connectors.activecampaign.dto.CustomDataAttribute;
import io.castled.apps.connectors.activecampaign.dto.CustomDataAttributeResponse;
import io.castled.apps.connectors.activecampaign.dto.FailureReason;
import io.castled.apps.connectors.activecampaign.models.ContactAndError;
import io.castled.exceptions.CastledRuntimeException;
import io.castled.utils.JsonUtils;
import io.castled.utils.ThreadUtils;
import io.castled.utils.TimeUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveCampaignRestClient {
    private static final Logger log = LoggerFactory.getLogger(ActiveCampaignRestClient.class);
    private final Client client;
    private String apiURL = null;
    private String apiKey = null;

    public ActiveCampaignRestClient(String apiURL, String apiKey) {
        this.apiKey = apiKey;
        this.apiURL = apiURL;
        this.client = (Client)ObjectRegistry.getInstance(Client.class);
    }

    public List<CustomDataAttribute> getContactCustomFields() {
        return ((CustomDataAttributeResponse)this.client.target(String.format("%s/api/%s/fields", this.apiURL, "3")).request(new String[]{"application/json"}).header(ActiveCampaignConstants.API_TOKEN_HEADER, (Object)this.apiKey).get(CustomDataAttributeResponse.class)).getFields();
    }

    public List<ContactAndError> upsertContacts(List<Contact> contacts) {
        ArrayList<ContactAndError> contactAndErrors = new ArrayList<ContactAndError>();
        boolean isRunCompleted = false;
        while (!isRunCompleted) {
            try {
                BulkImportResponse bulkImportResponse = this.invokeBulkImport(contacts);
                Integer responseType = bulkImportResponse.getSuccess();
                log.info("Response : " + responseType);
                isRunCompleted = responseType == 1 ? this.handleSuccessResponse(contacts, contactAndErrors, bulkImportResponse) : this.handleFailureResponse(contacts, contactAndErrors, bulkImportResponse);
            }
            catch (BadRequestException badRequestException) {
                log.error("Upsert failed : ", (Throwable)badRequestException);
                contactAndErrors.addAll(contacts.stream().map(contact -> new ContactAndError((Contact)contact, Collections.singletonList(badRequestException.getMessage()))).collect(Collectors.toList()));
            }
            catch (Exception e) {
                log.error("Upsert failed", (Throwable)e);
                throw new CastledRuntimeException((Throwable)e);
            }
        }
        return contactAndErrors;
    }

    private boolean handleFailureResponse(List<Contact> contacts, List<ContactAndError> contactAndErrors, BulkImportResponse bulkImportResponse) {
        List<FailureReason> failureReasons = bulkImportResponse.getFailureReasons();
        Map<Integer, List<FailureReason>> contactIndexToFailureReasonsMap = failureReasons.stream().filter(failureReason -> failureReason.getContact() != null).collect(Collectors.groupingBy(FailureReason::getContact));
        contactAndErrors.addAll(contactIndexToFailureReasonsMap.entrySet().stream().map(failedReason -> new ContactAndError((Contact)contacts.get((Integer)failedReason.getKey()), ((List)failedReason.getValue()).stream().map(FailureReason::getFailureReason).collect(Collectors.toList()))).collect(Collectors.toList()));
        List failedContacts = contactAndErrors.stream().map(ContactAndError::getContact).collect(Collectors.toList());
        contacts.removeAll(failedContacts);
        return CollectionUtils.isEmpty(contacts);
    }

    private boolean handleSuccessResponse(List<Contact> contacts, List<ContactAndError> contactAndErrors, BulkImportResponse bulkImportResponse) {
        ArrayList<String> failures = new ArrayList<String>();
        BulkImportStatusInfoResponse bulkImportStatusInfoResponse = null;
        do {
            ThreadUtils.interruptIgnoredSleep((long)TimeUtils.secondsToMillis((long)5L));
            log.info("Batch id :" + bulkImportResponse.getBatchId());
            bulkImportStatusInfoResponse = this.invokeBatchImportStatusCheck(bulkImportResponse.getBatchId());
            failures.addAll(new ArrayList<String>(bulkImportStatusInfoResponse.getFailure()));
        } while (!bulkImportStatusInfoResponse.getStatus().equalsIgnoreCase("completed"));
        contactAndErrors.addAll(failures.stream().map(failure -> new ContactAndError((Contact)contacts.get(Integer.parseInt(failure)), Collections.singletonList(bulkImportResponse.getMessage()))).collect(Collectors.toList()));
        return true;
    }

    private BulkImportResponse invokeBulkImport(List<Contact> contacts) {
        String response = (String)this.client.target(String.format("%s/api/%s/import/bulk_import", this.apiURL, "3")).request(new String[]{"application/json"}).header(ActiveCampaignConstants.API_TOKEN_HEADER, (Object)this.apiKey).post(Entity.json((Object)new BulkImportRequest(contacts)), String.class);
        return (BulkImportResponse)JsonUtils.jsonStringToObject((String)response, BulkImportResponse.class);
    }

    private BulkImportStatusInfoResponse invokeBatchImportStatusCheck(String batchId) {
        String statusCheck = (String)this.client.target(String.format("%s/api/%s/import/info", this.apiURL, "3")).queryParam("batchId", new Object[]{batchId}).request(new String[]{"application/json"}).header(ActiveCampaignConstants.API_TOKEN_HEADER, (Object)this.apiKey).get(String.class);
        return (BulkImportStatusInfoResponse)JsonUtils.jsonStringToObject((String)statusCheck, BulkImportStatusInfoResponse.class);
    }
}

