/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BufferedObjectSink<T> {
    private static final Logger log = LoggerFactory.getLogger(BufferedObjectSink.class);
    protected final List<T> objects = Lists.newArrayList();

    public void writeRecord(T object) {
        this.objects.add(object);
        if ((long)this.objects.size() >= this.getMaxBufferedObjects()) {
            this.flushBufferedRecords(this.objects);
            this.objects.clear();
        }
    }

    public void flushBufferedRecords(List<T> records) {
        if (CollectionUtils.isNotEmpty(records)) {
            this.writeRecords(records);
        }
    }

    protected abstract void writeRecords(List<T> var1);

    public void flushRecords() throws Exception {
        if (this.objects.size() > 0) {
            this.flushBufferedRecords(this.objects);
            this.objects.clear();
        }
        this.afterRecordsFlush();
    }

    public void afterRecordsFlush() {
    }

    public abstract long getMaxBufferedObjects();
}

