/*
 * Decompiled with CFR 0.152.
 */
package io.castled.warehouses.connectors.snowflake;

import com.amazonaws.regions.Regions;
import io.castled.forms.FormField;
import io.castled.forms.FormFieldSchema;
import io.castled.forms.FormFieldType;
import io.castled.forms.OptionsRef;
import io.castled.forms.OptionsRefType;
import io.castled.warehouses.BaseWarehouseConfig;

public class SnowflakeWarehouseConfig
extends BaseWarehouseConfig {
    @FormField(description="URL Prefix https://<account_name>.snowflake-computing.com", title="Account Name", placeholder="e.g. ab12345.us-east-2.aws", schema=FormFieldSchema.STRING, type=FormFieldType.TEXT_BOX)
    private String accountName;
    @FormField(description="Warehouse Name", title="Warehouse Name", placeholder="e.g. COMPUTE_WH", schema=FormFieldSchema.STRING, type=FormFieldType.TEXT_BOX)
    private String warehouseName;
    @FormField(description="Database name", title="Database Name", placeholder="e.g. demo_db", schema=FormFieldSchema.STRING, type=FormFieldType.TEXT_BOX)
    private String dbName;
    @FormField(description="Database User", title="Database User", placeholder="e.g. db_user", schema=FormFieldSchema.STRING, type=FormFieldType.TEXT_BOX)
    private String dbUser;
    @FormField(description="Database password", title="Database Password", schema=FormFieldSchema.STRING, type=FormFieldType.PASSWORD)
    private String dbPassword;
    @FormField(description="Schema", title="Schema Name", placeholder="e.g. demo_schema", schema=FormFieldSchema.STRING, type=FormFieldType.TEXT_BOX)
    private String schemaName;
    @FormField(description="S3 Bucket to be used as the staging area", title="S3 Bucket", placeholder="e.g. demo-bucket", schema=FormFieldSchema.STRING, type=FormFieldType.TEXT_BOX)
    private String s3Bucket;
    @FormField(description="S3 Access Key Id", title="S3 Access Key Id", placeholder="e.g. AKIAIOSFODNN7EXAMPLE", schema=FormFieldSchema.STRING, type=FormFieldType.TEXT_BOX)
    private String accessKeyId;
    @FormField(description="S3 Access Key Secret", title="S3 Access Key Secret", placeholder="e.g. wJalrXUtnFEMI/K7MDENG/bPxRfiCYEXAMPLEKEY", schema=FormFieldSchema.STRING, type=FormFieldType.TEXT_BOX)
    private String accessKeySecret;
    @FormField(description="S3 Bucket Location", title="S3 Bucket Location", schema=FormFieldSchema.ENUM, type=FormFieldType.DROP_DOWN, optionsRef=@OptionsRef(value="AWS_REGIONS", type=OptionsRefType.STATIC))
    private Regions region;

    public String getDbHost() {
        return this.getAccountName() + ".snowflakecomputing.com";
    }

    public int getDbPort() {
        return 443;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String getWarehouseName() {
        return this.warehouseName;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getDbUser() {
        return this.dbUser;
    }

    public String getDbPassword() {
        return this.dbPassword;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getS3Bucket() {
        return this.s3Bucket;
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public String getAccessKeySecret() {
        return this.accessKeySecret;
    }

    public Regions getRegion() {
        return this.region;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public void setDbUser(String dbUser) {
        this.dbUser = dbUser;
    }

    public void setDbPassword(String dbPassword) {
        this.dbPassword = dbPassword;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public void setS3Bucket(String s3Bucket) {
        this.s3Bucket = s3Bucket;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    public void setAccessKeySecret(String accessKeySecret) {
        this.accessKeySecret = accessKeySecret;
    }

    public void setRegion(Regions region) {
        this.region = region;
    }
}

