/*
 * Decompiled with CFR 0.152.
 */
package io.castled.warehouses.connectors.snowflake;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.castled.ObjectRegistry;
import io.castled.constants.ConnectorExecutionConstants;
import io.castled.exceptions.connect.ConnectException;
import io.castled.exceptions.connect.ConnectionError;
import io.castled.jdbc.JdbcConnectionManager;
import io.castled.jdbc.JdbcConnectionType;
import io.castled.jdbc.snowflake.SnowflakeQueryHelper;
import io.castled.models.QueryResults;
import io.castled.schema.ResultSetSchemaMapper;
import io.castled.schema.models.RecordSchema;
import io.castled.warehouses.TableProperties;
import io.castled.warehouses.WarehouseDataPoller;
import io.castled.warehouses.WarehouseSyncFailureListener;
import io.castled.warehouses.connectors.snowflake.SnowflakeClient;
import io.castled.warehouses.connectors.snowflake.SnowflakeDataPoller;
import io.castled.warehouses.connectors.snowflake.SnowflakeSyncFailureListener;
import io.castled.warehouses.connectors.snowflake.SnowflakeWarehouseConfig;
import io.castled.warehouses.jdbc.JdbcWarehouseConnector;
import io.castled.warehouses.models.WarehousePollContext;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SnowflakeConnector
extends JdbcWarehouseConnector<SnowflakeWarehouseConfig> {
    private static final Logger log = LoggerFactory.getLogger(SnowflakeConnector.class);
    private final SnowflakeQueryHelper snowflakeQueryHelper;
    private final ResultSetSchemaMapper resultSetSchemaMapper;
    private final SnowflakeClient snowflakeClient;

    @Inject
    public SnowflakeConnector(SnowflakeQueryHelper snowflakeQueryHelper, ResultSetSchemaMapper resultSetSchemaMapper, SnowflakeClient snowflakeClient) {
        this.snowflakeQueryHelper = snowflakeQueryHelper;
        this.resultSetSchemaMapper = resultSetSchemaMapper;
        this.snowflakeClient = snowflakeClient;
    }

    @Override
    public void testConnectionForDataPoll(SnowflakeWarehouseConfig config) throws ConnectException {
        if (!this.validateAccountName(config.getAccountName())) {
            throw new ConnectException(ConnectionError.INVALID_CONFIG, String.format("Account name should of the format [%s].[%s].[%s]", "account_locator", "region", "cloud_provider"));
        }
        try (Connection connection = this.getConnection(config);){
            List<String> schemas = this.snowflakeClient.listSchemas(connection);
            if (!schemas.contains("castled".toUpperCase())) {
                throw new ConnectException(ConnectionError.INCOMPLETE_SETUP, String.format("%s schema does not exist. Please create the castled schema as mentioned in our doc", "castled"));
            }
        }
        catch (Exception e) {
            log.error("Test connection failed for snowflake warehouse", (Throwable)e);
            throw new ConnectException(ConnectionError.UNKNOWN, Optional.ofNullable(e.getMessage()).orElse("Unknown Error"));
        }
    }

    private boolean validateAccountName(String accountName) {
        String[] tokens = accountName.split("\\.");
        return tokens.length == 3;
    }

    @Override
    public WarehouseDataPoller getDataPoller() {
        return (WarehouseDataPoller)ObjectRegistry.getInstance(SnowflakeDataPoller.class);
    }

    @Override
    public RecordSchema getQuerySchema(SnowflakeWarehouseConfig snowflakeWarehouseConfig, String query) throws Exception {
        try (Connection connection = this.getConnection(snowflakeWarehouseConfig);){
            RecordSchema recordSchema;
            block12: {
                PreparedStatement preparedStatement = connection.prepareStatement(query);
                try {
                    recordSchema = this.resultSetSchemaMapper.getSchema(preparedStatement.getMetaData());
                    if (preparedStatement == null) break block12;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return recordSchema;
        }
    }

    @Override
    public WarehouseSyncFailureListener syncFailureListener(WarehousePollContext warehousePollContext) throws Exception {
        return new SnowflakeSyncFailureListener(warehousePollContext);
    }

    @Override
    public TableProperties getSnapshotTableProperties(List<String> recordIdKeys) {
        return null;
    }

    @Override
    public void restartPoll(String pipelineUUID, SnowflakeWarehouseConfig snowflakeWarehouseConfig) throws Exception {
        try (Connection connection = this.getConnection(snowflakeWarehouseConfig);
             Statement statement = connection.createStatement();){
            statement.execute(String.format("drop table if exists %s", ConnectorExecutionConstants.getQualifiedCommittedSnapshot(pipelineUUID)));
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public QueryResults previewQuery(String query, SnowflakeWarehouseConfig snowflakeWarehouseConfig, int maxRows) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Connection getConnection(SnowflakeWarehouseConfig config) throws SQLException {
        JdbcConnectionManager jdbcConnectionManager = (JdbcConnectionManager)ObjectRegistry.getInstance(JdbcConnectionManager.class);
        return jdbcConnectionManager.getTunneledConnection(this.getConnectionType(), config.getDbUser(), config.getDbPassword(), config.getDbName(), config.getSchemaName(), config.getDbHost(), config.getDbPort(), null, this.snowflakeQueryHelper.getConnectionProperties(config.getWarehouseName(), config.getDbName(), config.getSchemaName()));
    }

    @Override
    public JdbcConnectionType getConnectionType() {
        return JdbcConnectionType.SNOWFLAKE;
    }

    @Override
    public Class<SnowflakeWarehouseConfig> getConfigType() {
        return SnowflakeWarehouseConfig.class;
    }

    @Override
    public SnowflakeWarehouseConfig filterRestrictedConfigDetails(SnowflakeWarehouseConfig snowflakeWarehouseConfig) {
        snowflakeWarehouseConfig.setDbPassword(null);
        return snowflakeWarehouseConfig;
    }
}

