/*
 * Decompiled with CFR 0.152.
 */
package io.castled.warehouses;

import com.google.common.collect.Lists;
import io.castled.commons.streams.RecordOutputStream;
import io.castled.constants.ConnectorExecutionConstants;
import io.castled.schema.models.Field;
import io.castled.schema.models.FieldSchema;
import io.castled.schema.models.Tuple;
import io.castled.warehouses.WarehouseConfig;
import io.castled.warehouses.models.WarehousePollContext;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public abstract class WarehouseSyncFailureListener
implements RecordOutputStream {
    protected final List<String> trackableFields;
    protected final WarehousePollContext warehousePollContext;
    protected final Path failureRecordsDirectory;
    private boolean flushed = false;

    public WarehouseSyncFailureListener(WarehousePollContext warehousePollContext) {
        this.trackableFields = this.getTrackableFields(warehousePollContext);
        this.warehousePollContext = warehousePollContext;
        this.failureRecordsDirectory = ConnectorExecutionConstants.FAILURE_RECORDS_DIR.resolve(warehousePollContext.getPipelineUUID()).resolve(String.valueOf(warehousePollContext.getPipelineRunId()));
    }

    @Override
    public void writeRecord(Tuple record) throws Exception {
        Tuple.Builder recordBuilder = Tuple.builder().name(record.getName());
        for (Field field : record.getFields()) {
            if (!this.trackableFields.contains(field.getName())) continue;
            recordBuilder.put(field);
        }
        this.doWriteRecord(recordBuilder.build());
    }

    private List<String> getTrackableFields(WarehousePollContext warehousePollContext) {
        ArrayList trackableFields = Lists.newArrayList();
        for (FieldSchema fieldSchema : warehousePollContext.getWarehouseSchema().getFieldSchemas()) {
            if (CollectionUtils.isNotEmpty(warehousePollContext.getPrimaryKeys()) && !warehousePollContext.getPrimaryKeys().contains(fieldSchema.getName())) continue;
            trackableFields.add(fieldSchema.getName());
        }
        return trackableFields;
    }

    public abstract void doWriteRecord(Tuple var1) throws Exception;

    @Override
    public void flush() throws Exception {
        if (this.flushed) {
            return;
        }
        this.doFlush();
        this.flushed = true;
    }

    public abstract void cleanupResources(String var1, Long var2, WarehouseConfig var3);

    public abstract void doFlush() throws Exception;
}

