/*
 * Decompiled with CFR 0.152.
 */
package io.castled.models;

import io.castled.models.CastledDataMapping;
import io.castled.models.FieldMapping;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class TargetFieldsMapping
extends CastledDataMapping {
    private List<FieldMapping> fieldMappings;

    public Map<String, String> getMappingForAppFields(List<String> appFields) {
        return this.fieldMappings.stream().filter(fieldMapping -> appFields.contains(fieldMapping.getAppField())).collect(Collectors.toMap(FieldMapping::getAppField, FieldMapping::getWarehouseField));
    }

    public Map<String, String> appWarehouseMapping() {
        return this.fieldMappings.stream().filter(fieldMapping -> !fieldMapping.isSkipped()).collect(Collectors.toMap(FieldMapping::getAppField, FieldMapping::getWarehouseField));
    }

    public Map<String, String> warehouseAppMapping() {
        return this.fieldMappings.stream().filter(fieldMapping -> !fieldMapping.isSkipped()).collect(Collectors.toMap(FieldMapping::getWarehouseField, FieldMapping::getAppField));
    }

    public void addAdditionalMappings(List<FieldMapping> additionalMappings) {
        this.fieldMappings.addAll(additionalMappings);
    }

    public List<FieldMapping> getFieldMappings() {
        return this.fieldMappings;
    }

    public void setFieldMappings(List<FieldMapping> fieldMappings) {
        this.fieldMappings = fieldMappings;
    }
}

