/*
 * Decompiled with CFR 0.152.
 */
package io.castled.filestorage;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.AmazonS3EncryptionClientBuilder;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.CryptoConfiguration;
import com.amazonaws.services.s3.model.CryptoMode;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.EncryptionMaterials;
import com.amazonaws.services.s3.model.EncryptionMaterialsProvider;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.model.StaticEncryptionMaterialsProvider;
import com.amazonaws.services.s3.transfer.Download;
import com.amazonaws.services.s3.transfer.MultipleFileUpload;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.TransferManagerBuilder;
import com.google.common.collect.Lists;
import io.castled.exceptions.CastledRuntimeException;
import io.castled.filestorage.ObjectStoreClient;
import io.castled.filestorage.ObjectStoreException;
import io.castled.utils.JsonUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.stream.Collectors;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CastledS3Client
implements ObjectStoreClient {
    private static final Logger log = LoggerFactory.getLogger(CastledS3Client.class);
    private final AmazonS3 s3Client;
    private final TransferManager transferManager;
    private final String bucket;
    private final Regions region;
    private final String encryptionKey;
    private static final String SCHEME = "s3://";
    public static final String PATH_SEPARATOR = "/";

    public CastledS3Client(AWSCredentialsProvider awsCredentialsProvider, String encryptionKey, Regions region, String bucket) {
        this.s3Client = this.getAmazonS3(awsCredentialsProvider, encryptionKey, region);
        this.transferManager = TransferManagerBuilder.standard().withS3Client(this.s3Client).build();
        this.bucket = bucket;
        this.encryptionKey = encryptionKey;
        this.region = region;
    }

    public CastledS3Client(String accessKeyId, String accessKeySecret, String encryptionKey, Regions region, String bucket) {
        this((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(accessKeyId, accessKeySecret)), encryptionKey, region, bucket);
    }

    private AmazonS3 getAmazonS3(AWSCredentialsProvider awsCredentialsProvider, String encryptionKey, Regions region) {
        if (encryptionKey == null || encryptionKey.trim().isEmpty()) {
            return (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials(awsCredentialsProvider)).withRegion(region)).build();
        }
        SecretKeySpec secretKey = new SecretKeySpec(Base64.getDecoder().decode(encryptionKey), "AES");
        return (AmazonS3)((AmazonS3EncryptionClientBuilder)((AmazonS3EncryptionClientBuilder)AmazonS3EncryptionClientBuilder.standard().withCredentials(awsCredentialsProvider)).withRegion(region)).withCryptoConfiguration(new CryptoConfiguration(CryptoMode.EncryptionOnly)).withEncryptionMaterials((EncryptionMaterialsProvider)new StaticEncryptionMaterialsProvider(new EncryptionMaterials((SecretKey)secretKey))).build();
    }

    @Override
    public void uploadFile(String key, File file) throws ObjectStoreException {
        try {
            this.s3Client.putObject(this.bucket, key, file);
        }
        catch (Exception e) {
            log.error("Upload file failed for bucket {} and key {}", (Object)this.bucket, (Object)key);
            throw new ObjectStoreException(e.getMessage(), e);
        }
    }

    public void uploadText(String key, String objectAsString) throws ObjectStoreException {
        try {
            ObjectMetadata metaData = new ObjectMetadata();
            byte[] contentBytes = objectAsString.getBytes();
            metaData.setContentLength((long)contentBytes.length);
            ByteArrayInputStream is = new ByteArrayInputStream(contentBytes);
            this.s3Client.putObject(new PutObjectRequest(this.getBucket(), key, (InputStream)is, metaData));
        }
        catch (Exception e) {
            log.error("Upload text failed for bucket {} and key {}", (Object)this.bucket, (Object)key);
            throw new ObjectStoreException(e.getMessage(), e);
        }
    }

    public void uploadDirectory(Path directory, String s3DirectoryPrefix) {
        try {
            MultipleFileUpload multipleFileUpload = this.transferManager.uploadDirectory(this.bucket, s3DirectoryPrefix, directory.toFile(), true);
            multipleFileUpload.waitForCompletion();
        }
        catch (Exception e) {
            log.error("Directory {} upload failed to s3", (Object)directory.toString());
            throw new CastledRuntimeException((Throwable)e);
        }
    }

    public String getObjectAsString(String key) {
        try {
            return this.s3Client.getObjectAsString(this.bucket, key);
        }
        catch (AmazonS3Exception e) {
            if (e.getErrorCode().equals("NoSuchKey")) {
                return null;
            }
            throw e;
        }
    }

    public static String constructS3Path(String bucket, List<String> keyParts) {
        return String.format("%s%s%s", SCHEME, bucket + PATH_SEPARATOR, String.join((CharSequence)PATH_SEPARATOR, keyParts));
    }

    public static String constructObjectKey(List<String> keyParts) {
        return String.join((CharSequence)PATH_SEPARATOR, keyParts);
    }

    public static ImmutablePair<String, String> getBucketAndKey(String url) {
        String[] schemeAndRest = url.split("://");
        if (schemeAndRest.length != 2) {
            throw new CastledRuntimeException("Invalid s3 url: " + url);
        }
        String[] urlParts = schemeAndRest[1].split(PATH_SEPARATOR);
        ArrayList keyParts = Lists.newArrayList(Arrays.asList(urlParts).subList(1, urlParts.length));
        return new ImmutablePair((Object)urlParts[0], (Object)String.join((CharSequence)PATH_SEPARATOR, keyParts));
    }

    public static String getFileName(String objectKey) {
        String[] keyParts = objectKey.split(PATH_SEPARATOR);
        if (keyParts.length == 0) {
            throw new CastledRuntimeException("Invalid object key " + objectKey);
        }
        return keyParts[keyParts.length - 1];
    }

    public List<Path> downloadFiles(List<String> objectKeys, Path downloadDir) {
        try {
            ArrayList submittedDownloads = Lists.newArrayList();
            ArrayList localFiles = Lists.newArrayList();
            for (String objectKey : objectKeys) {
                String fileName = CastledS3Client.getFileName(objectKey);
                localFiles.add(downloadDir.resolve(fileName));
                submittedDownloads.add(this.transferManager.download(this.bucket, objectKey, downloadDir.resolve(fileName).toFile()));
            }
            for (Download submittedDownload : submittedDownloads) {
                submittedDownload.waitForCompletion();
            }
            return localFiles;
        }
        catch (Exception e) {
            log.error("Download files {} failed", (Object)JsonUtils.objectToString(objectKeys), (Object)e);
            throw new CastledRuntimeException((Throwable)e);
        }
    }

    public List<String> listObjectUrls(String directoryKey) {
        return this.listObjects(directoryKey).stream().map(s3ObjectSummary -> CastledS3Client.constructS3Path(s3ObjectSummary.getBucketName(), Lists.newArrayList((Object[])new String[]{s3ObjectSummary.getKey()}))).collect(Collectors.toList());
    }

    public List<S3ObjectSummary> listObjects(String directoryKey) {
        ArrayList s3ObjectSummaries = Lists.newArrayList();
        ObjectListing objectListing = this.s3Client.listObjects(new ListObjectsRequest().withBucketName(this.bucket).withPrefix(directoryKey));
        s3ObjectSummaries.addAll(objectListing.getObjectSummaries());
        while (objectListing.isTruncated()) {
            objectListing = this.s3Client.listNextBatchOfObjects(objectListing);
            s3ObjectSummaries.addAll(objectListing.getObjectSummaries());
        }
        return s3ObjectSummaries;
    }

    public void deleteDirectory(String directoryKey) {
        List<S3ObjectSummary> objectSummaries = this.listObjects(directoryKey);
        if (CollectionUtils.isNotEmpty(objectSummaries)) {
            DeleteObjectsRequest deleteObjectsRequest = new DeleteObjectsRequest(this.bucket).withKeys((String[])objectSummaries.stream().map(S3ObjectSummary::getKey).toArray(String[]::new));
            this.s3Client.deleteObjects(deleteObjectsRequest);
        }
    }

    public String getBucket() {
        return this.bucket;
    }

    public Regions getRegion() {
        return this.region;
    }

    public String getEncryptionKey() {
        return this.encryptionKey;
    }
}

