/*
 * Decompiled with CFR 0.152.
 */
package io.castled.commons.util;

import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import io.castled.commons.models.ServiceAccountDetails;
import io.castled.exceptions.CastledRuntimeException;
import io.castled.utils.JsonUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleAuthUtil {
    private static final Logger log = LoggerFactory.getLogger(GoogleAuthUtil.class);

    public static Credentials getCredentials(ServiceAccountDetails serviceAccountDetails) {
        try {
            ByteArrayInputStream serviceAccountStream = new ByteArrayInputStream(JsonUtils.objectToByteArray((Object)serviceAccountDetails));
            return GoogleCredentials.fromStream((InputStream)serviceAccountStream).createScoped(Collections.singleton("https://www.googleapis.com/auth/cloud-platform"));
        }
        catch (IOException e) {
            log.error(String.format("Service account credentials fetch failed for %s", serviceAccountDetails.getClientEmail()));
            throw new CastledRuntimeException((Throwable)e);
        }
    }
}

