/*
 * Decompiled with CFR 0.152.
 */
package io.castled.commons.streams;

import io.castled.commons.streams.MessageInputStream;
import io.castled.commons.streams.RecordInputStream;
import io.castled.schema.models.Message;
import io.castled.schema.models.Tuple;

public class MessageInputStreamImpl
implements MessageInputStream {
    private final RecordInputStream recordInputStream;
    private long count = 1L;
    private final long startingOffset;

    public MessageInputStreamImpl(RecordInputStream recordInputStream, long startingOffset) {
        this.recordInputStream = recordInputStream;
        this.startingOffset = startingOffset;
    }

    @Override
    public Message readMessage() throws Exception {
        Tuple record = this.recordInputStream.readRecord();
        if (record == null) {
            return null;
        }
        while (this.count <= this.startingOffset) {
            this.recordInputStream.readRecord();
            ++this.count;
        }
        return new Message(this.count++, record);
    }

    @Override
    public void close() throws Exception {
        this.recordInputStream.close();
    }
}

