/*
 * Decompiled with CFR 0.152.
 */
package io.castled.commons.streams;

import io.castled.commons.errors.CastledError;
import io.castled.commons.errors.CastledErrorTracker;
import io.castled.commons.streams.RecordOutputStream;
import io.castled.exceptions.CastledRuntimeException;
import io.castled.schema.models.Message;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorOutputStream {
    private static final Logger log = LoggerFactory.getLogger(ErrorOutputStream.class);
    private final RecordOutputStream recordOutputStream;
    private final CastledErrorTracker castledErrorTracker;
    private final AtomicLong failedRecords = new AtomicLong(0L);
    private volatile Long firstFailedMessageId;

    public ErrorOutputStream(RecordOutputStream recordOutputStream, CastledErrorTracker castledErrorTracker) {
        this.recordOutputStream = recordOutputStream;
        this.castledErrorTracker = castledErrorTracker;
    }

    public void writeFailedRecord(Message message, CastledError pipelineError) {
        try {
            if (this.firstFailedMessageId == null) {
                this.firstFailedMessageId = message.getOffset();
            }
            this.failedRecords.incrementAndGet();
            this.castledErrorTracker.writeError(message.getRecord(), pipelineError);
            this.recordOutputStream.writeRecord(message.getRecord());
        }
        catch (Exception e) {
            log.error(String.format("Write failed record failed for error %s", pipelineError.description()), (Throwable)e);
            throw new CastledRuntimeException((Throwable)e);
        }
    }

    public void flushFailedRecords() throws Exception {
        this.recordOutputStream.flush();
        this.castledErrorTracker.flushErrors();
    }

    public AtomicLong getFailedRecords() {
        return this.failedRecords;
    }

    public Long getFirstFailedMessageId() {
        return this.firstFailedMessageId;
    }
}

