/*
 * Decompiled with CFR 0.152.
 */
package io.castled.commons.errors.errorclassifications;

import io.castled.commons.errors.CastledError;
import io.castled.commons.errors.CastledErrorCode;
import java.util.Collections;
import java.util.List;

public class MissingRequiredFieldsError
extends CastledError {
    private final List<String> missingFields;

    public MissingRequiredFieldsError(List<String> missingFields) {
        super(CastledErrorCode.REQUIRED_FIELDS_MISSING);
        this.missingFields = missingFields;
    }

    @Override
    public String uniqueId() {
        Collections.sort(this.missingFields);
        return String.join((CharSequence)"_", this.missingFields);
    }

    @Override
    public String description() {
        if (this.missingFields.size() == 1) {
            return String.format("Required field [%s] missing", this.missingFields.get(0));
        }
        return String.format("Required fields [%s] missing", String.join((CharSequence)",", this.missingFields));
    }
}

