/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.restapi;

import io.castled.apps.DataSink;
import io.castled.apps.connectors.restapi.RestApiObjectSync;
import io.castled.apps.models.DataSinkRequest;
import io.castled.commons.models.AppSyncStats;
import io.castled.schema.models.Message;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestApiDataSink
implements DataSink {
    private static final Logger log = LoggerFactory.getLogger(RestApiDataSink.class);
    private volatile RestApiObjectSync restApiObjectSink;

    @Override
    public void syncRecords(DataSinkRequest dataSinkRequest) throws Exception {
        Message message;
        this.restApiObjectSink = new RestApiObjectSync(dataSinkRequest);
        while ((message = dataSinkRequest.getMessageInputStream().readMessage()) != null) {
            this.restApiObjectSink.writeRecord(message);
        }
        this.restApiObjectSink.flushRecords();
    }

    @Override
    public AppSyncStats getSyncStats() {
        return Optional.ofNullable(this.restApiObjectSink).map(audienceSinkRef -> this.restApiObjectSink.getSyncStats()).map(statsRef -> new AppSyncStats(statsRef.getRecordsProcessed(), statsRef.getOffset(), 0L)).orElse(new AppSyncStats(0L, 0L, 0L));
    }
}

