/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.intercom.client;

import com.google.common.collect.Maps;
import io.castled.ObjectRegistry;
import io.castled.apps.connectors.intercom.client.dtos.DataAttribute;
import io.castled.apps.connectors.intercom.client.dtos.DataAttributesResponse;
import io.castled.apps.connectors.intercom.client.dtos.IntercomErrorResponse;
import io.castled.apps.connectors.intercom.client.dtos.IntercomEvent;
import io.castled.apps.connectors.intercom.client.dtos.PaginatedObjectList;
import io.castled.apps.connectors.intercom.client.exceptions.IntercomRestException;
import io.castled.apps.connectors.intercom.client.models.IntercomModel;
import io.castled.utils.JsonUtils;
import io.castled.utils.ResponseUtils;
import io.castled.utils.ThreadUtils;
import io.castled.utils.TimeUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntercomRestClient {
    private static final Logger log = LoggerFactory.getLogger(IntercomRestClient.class);
    private final Client client = (Client)ObjectRegistry.getInstance(Client.class);
    private final String accessToken;

    public IntercomRestClient(String accessToken) {
        this.accessToken = accessToken;
    }

    public List<DataAttribute> listAttributes(IntercomModel intercomModel) {
        return ((DataAttributesResponse)this.client.target("https://api.intercom.io/data_attributes").queryParam("model", new Object[]{intercomModel.getName()}).request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + this.accessToken)).get(DataAttributesResponse.class)).getData();
    }

    public void createContact(Map<String, Object> contactProperties, List<String> customAttributes) throws IntercomRestException {
        Map<String, Object> requestProperties = this.constructRequestObject(contactProperties, customAttributes);
        Response response = this.executeRequest(() -> this.client.target("https://api.intercom.io/contacts").request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + this.accessToken)).post(Entity.json((Object)requestProperties)));
        if (response != null) {
            response.close();
        }
    }

    public void createOrUpdateContact(Map<String, Object> contactProperties, List<String> customAttributes) throws IntercomRestException {
        try {
            this.createContact(contactProperties, customAttributes);
        }
        catch (IntercomRestException e) {
            Matcher matcher = Pattern.compile("A contact matching those details already exists with id=(.*)").matcher(e.getMessage());
            if (matcher.find()) {
                String contactId = matcher.group(1);
                this.updateContact(contactId, contactProperties, customAttributes);
                return;
            }
            throw e;
        }
    }

    public void updateContact(String contactId, Map<String, Object> contactProperties, List<String> customAttributes) throws IntercomRestException {
        Map<String, Object> requestProperties = this.constructRequestObject(contactProperties, customAttributes);
        Response response = this.executeRequest(() -> this.client.target(String.format("https://api.intercom.io/contacts/%s", contactId)).request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + this.accessToken)).put(Entity.json((Object)requestProperties)));
        if (response != null) {
            response.close();
        }
    }

    public void createCompany(Map<String, Object> companyProperties, List<String> customAttributes) throws IntercomRestException {
        Map<String, Object> requestProperties = this.constructRequestObject(companyProperties, customAttributes);
        Response response = this.executeRequest(() -> this.client.target("https://api.intercom.io/companies").request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + this.accessToken)).post(Entity.json((Object)requestProperties)));
        if (response != null) {
            response.close();
        }
    }

    public void updateCompany(String companyId, Map<String, Object> companyProperties, List<String> customAttributes) {
    }

    public void consumeContacts(Consumer<Map<String, Object>> contactsConsumer) {
        PaginatedObjectList contactList = (PaginatedObjectList)this.client.target("https://api.intercom.io/contacts").queryParam("per_page", new Object[]{150}).request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + this.accessToken)).get(PaginatedObjectList.class);
        contactList.getData().stream().map(this::flattenPropertyResponse).forEach(contactsConsumer);
        while (contactList.getPages().getNextOffset() != null) {
            contactList = (PaginatedObjectList)this.client.target("https://api.intercom.io/contacts").queryParam("per_page", new Object[]{150}).queryParam("starting_after", new Object[]{contactList.getPages().getNextOffset()}).request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + this.accessToken)).get(PaginatedObjectList.class);
            contactList.getData().stream().map(this::flattenPropertyResponse).forEach(contactsConsumer);
        }
    }

    private Map<String, Object> flattenPropertyResponse(Map<String, Object> properties) {
        HashMap flattenedProperties = Maps.newHashMap();
        Map customProperties = (Map)properties.get("custom_attributes");
        flattenedProperties.putAll(properties);
        flattenedProperties.remove("custom_properties");
        flattenedProperties.putAll(customProperties);
        return flattenedProperties;
    }

    private Map<String, Object> constructRequestObject(Map<String, Object> properties, List<String> customAttributes) {
        HashMap requestProperties = Maps.newHashMap();
        HashMap customProperties = CollectionUtils.isNotEmpty(customAttributes) ? customAttributes.stream().filter(attribute -> properties.get(attribute) != null).collect(Collectors.toMap(Function.identity(), properties::get)) : Maps.newHashMap();
        requestProperties.putAll(properties);
        if (MapUtils.isNotEmpty((Map)customProperties)) {
            requestProperties.put("custom_attributes", customProperties);
        }
        customAttributes.forEach(requestProperties::remove);
        return requestProperties;
    }

    public void sendEvent(IntercomEvent intercomEvent) throws IntercomRestException {
        Response response = this.executeRequest(() -> this.client.target("https://api.intercom.io/events").request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + this.accessToken)).post(Entity.json((Object)intercomEvent)));
        if (response != null) {
            response.close();
        }
    }

    private Response executeRequest(Supplier<Response> supplier) throws IntercomRestException {
        return this.doExecuteRequest(supplier, 0, 3);
    }

    private Response doExecuteRequest(Supplier<Response> supplier, int retryCount, int maxRetries) throws IntercomRestException {
        Response response = supplier.get();
        if (!ResponseUtils.is2xx((Response)response)) {
            String errorString = (String)response.readEntity(String.class);
            IntercomErrorResponse errorResponse = (IntercomErrorResponse)JsonUtils.jsonStringToObject((String)errorString, IntercomErrorResponse.class);
            if (errorResponse.getFirstError().getCode().equals("rate_limit_exceeded") && retryCount < maxRetries) {
                ThreadUtils.interruptIgnoredSleep((long)TimeUtils.secondsToMillis((long)10L));
                this.doExecuteRequest(supplier, retryCount + 1, maxRetries);
            }
            throw new IntercomRestException(errorResponse);
        }
        return response;
    }
}

