/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.intercom;

import io.castled.apps.connectors.intercom.IntercomObject;
import io.castled.apps.connectors.intercom.client.dtos.DataAttribute;
import io.castled.apps.connectors.intercom.client.models.IntercomModel;
import io.castled.exceptions.CastledRuntimeException;
import io.castled.schema.SchemaConstants;
import io.castled.schema.models.RecordSchema;
import io.castled.schema.models.Schema;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntercomUtils {
    private static final Logger log = LoggerFactory.getLogger(IntercomUtils.class);

    public static IntercomModel getIntercomModel(IntercomObject intercomObject) {
        switch (intercomObject) {
            case LEAD: 
            case USER: 
            case CONTACT: {
                return IntercomModel.CONTACT;
            }
            case COMPANY: {
                return IntercomModel.COMPANY;
            }
        }
        throw new CastledRuntimeException(String.format("Invalid intercom object %s", new Object[]{intercomObject}));
    }

    public static RecordSchema getSchema(IntercomObject intercomObject, List<DataAttribute> dataAttributes) {
        RecordSchema.Builder schemaBuilder = RecordSchema.builder().name(intercomObject.getName());
        for (DataAttribute dataAttribute : dataAttributes) {
            Schema fieldSchema = IntercomUtils.getFieldSchema(intercomObject, dataAttribute);
            if (fieldSchema == null) continue;
            schemaBuilder.put(dataAttribute.getName(), fieldSchema);
        }
        return schemaBuilder.build();
    }

    public static Schema getFieldSchema(IntercomObject intercomObject, DataAttribute dataAttribute) {
        if (!dataAttribute.isApiWritable() && !dataAttribute.getName().equals("company_id")) {
            return null;
        }
        if ((intercomObject == IntercomObject.USER || intercomObject == IntercomObject.LEAD) && dataAttribute.getName().equals("role")) {
            return null;
        }
        if (intercomObject == IntercomObject.CONTACT && dataAttribute.getName().equals("role")) {
            return SchemaConstants.STRING_SCHEMA;
        }
        switch (dataAttribute.getDataType()) {
            case "string": {
                return SchemaConstants.OPTIONAL_STRING_SCHEMA;
            }
            case "integer": {
                return SchemaConstants.OPTIONAL_LONG_SCHEMA;
            }
            case "float": {
                return SchemaConstants.OPTIONAL_DOUBLE_SCHEMA;
            }
            case "boolean": {
                return SchemaConstants.OPTIONAL_BOOL_SCHEMA;
            }
            case "date": {
                return SchemaConstants.ZONED_TIMESTAMP_SCHEMA;
            }
        }
        log.warn(String.format("Invalid data type %s", dataAttribute.getDataType()));
        return null;
    }
}

