/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.googlesheets;

import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.services.sheets.v4.Sheets;
import com.google.api.services.sheets.v4.model.BatchUpdateValuesRequest;
import com.google.api.services.sheets.v4.model.ValueRange;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.castled.apps.BufferedObjectSink;
import io.castled.apps.connectors.googlesheets.GoogleSheetUtils;
import io.castled.apps.connectors.googlesheets.GoogleSheetsAppConfig;
import io.castled.apps.connectors.googlesheets.GoogleSheetsAppSyncConfig;
import io.castled.apps.connectors.googlesheets.SheetRow;
import io.castled.commons.errors.errorclassifications.ExternallyCategorizedError;
import io.castled.commons.errors.errorclassifications.UnclassifiedError;
import io.castled.commons.models.MessageSyncStats;
import io.castled.commons.streams.ErrorOutputStream;
import io.castled.schema.models.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleSheetsObjectSink
extends BufferedObjectSink<Message> {
    private static final Logger log = LoggerFactory.getLogger(GoogleSheetsObjectSink.class);
    private final GoogleSheetsAppConfig googleSheetsAppConfig;
    private final GoogleSheetsAppSyncConfig googleSheetsAppSyncConfig;
    private final List<String> primaryKeys;
    private final AtomicLong processedRecords = new AtomicLong(0L);
    private long lastProcessedOffset = 0L;
    private final Sheets sheetsService;
    private final Map<Integer, SheetRow> hashedRows;
    private final List<String> headers;
    private final ErrorOutputStream errorOutputStream;

    public GoogleSheetsObjectSink(GoogleSheetsAppConfig googleSheetsAppConfig, GoogleSheetsAppSyncConfig googleSheetsAppSyncConfig, Sheets sheetsService, List<SheetRow> sheetRows, List<String> primaryKeys, List<String> headers, ErrorOutputStream errorOutputStream) {
        this.googleSheetsAppConfig = googleSheetsAppConfig;
        this.googleSheetsAppSyncConfig = googleSheetsAppSyncConfig;
        this.sheetsService = sheetsService;
        this.hashedRows = Optional.ofNullable(sheetRows).map(row -> row.stream().collect(Collectors.toMap(rowRef -> GoogleSheetUtils.getPrimaryKeysHash(rowRef.getValues(), primaryKeys), Function.identity()))).orElse(Maps.newHashMap());
        this.primaryKeys = primaryKeys;
        this.headers = headers;
        this.errorOutputStream = errorOutputStream;
    }

    @Override
    protected void writeRecords(List<Message> messages) {
        try {
            ArrayList updateValueRanges = Lists.newArrayList();
            ArrayList appendValues = Lists.newArrayList();
            for (Message message : messages) {
                LinkedHashMap rowValues = this.headers.stream().collect(Collectors.toMap(Function.identity(), header -> GoogleSheetUtils.getSheetsValue(message.getRecord().getField(header)), (v1, v2) -> v1, LinkedHashMap::new));
                int primaryKeyHash = GoogleSheetUtils.getPrimaryKeysHash(rowValues, this.primaryKeys);
                if (this.hashedRows.containsKey(primaryKeyHash)) {
                    SheetRow sheetRow = this.hashedRows.get(primaryKeyHash);
                    updateValueRanges.add(new ValueRange().setValues(Collections.singletonList(new ArrayList(rowValues.values()))).setRange(GoogleSheetUtils.getRange(this.googleSheetsAppSyncConfig.getObject().getObjectName(), sheetRow.getRowNo())));
                    this.hashedRows.remove(primaryKeyHash);
                    continue;
                }
                appendValues.add(new ArrayList(rowValues.values()));
            }
            if (CollectionUtils.isNotEmpty((Collection)updateValueRanges)) {
                BatchUpdateValuesRequest batchUpdateValuesRequest = new BatchUpdateValuesRequest().setData((List)updateValueRanges).setValueInputOption("USER_ENTERED");
                this.sheetsService.spreadsheets().values().batchUpdate(GoogleSheetUtils.getSpreadSheetId(this.googleSheetsAppConfig.getSpreadSheetId()), batchUpdateValuesRequest).execute();
            }
            if (CollectionUtils.isNotEmpty((Collection)appendValues)) {
                ValueRange valueRange = new ValueRange().setValues((List)appendValues);
                this.sheetsService.spreadsheets().values().append(GoogleSheetUtils.getSpreadSheetId(this.googleSheetsAppConfig.getSpreadSheetId()), this.googleSheetsAppSyncConfig.getObject().getObjectName(), valueRange).setValueInputOption("USER_ENTERED").execute();
            }
        }
        catch (Exception e) {
            this.handleGSheetsError(messages, e);
        }
        this.processedRecords.addAndGet(messages.size());
        this.lastProcessedOffset = Math.max(this.lastProcessedOffset, messages.get(messages.size() - 1).getOffset());
    }

    private void handleGSheetsError(List<Message> messages, Exception e) {
        log.error("Google Sheets append records failed for spreadsheet id {} and name {}", new Object[]{GoogleSheetUtils.getSpreadSheetId(this.googleSheetsAppConfig.getSpreadSheetId()), this.googleSheetsAppSyncConfig.getObject().getObjectName(), e});
        if (e instanceof GoogleJsonResponseException) {
            GoogleJsonResponseException gre = (GoogleJsonResponseException)e;
            for (Message message : messages) {
                this.errorOutputStream.writeFailedRecord(message, new ExternallyCategorizedError(gre.getStatusMessage(), gre.getContent()));
            }
            return;
        }
        for (Message message : messages) {
            this.errorOutputStream.writeFailedRecord(message, new UnclassifiedError(Optional.ofNullable(e.getMessage()).orElse("Unknown error")));
        }
    }

    public MessageSyncStats getSyncStats() {
        return new MessageSyncStats(this.processedRecords.get(), this.lastProcessedOffset);
    }

    @Override
    public long getMaxBufferedObjects() {
        return 10000L;
    }
}

