/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.googlesheets;

import com.google.api.services.sheets.v4.Sheets;
import com.google.api.services.sheets.v4.model.ClearValuesRequest;
import com.google.api.services.sheets.v4.model.ValueRange;
import com.google.common.collect.Lists;
import io.castled.apps.DataSink;
import io.castled.apps.connectors.googlesheets.GoogleSheetUtils;
import io.castled.apps.connectors.googlesheets.GoogleSheetsAppConfig;
import io.castled.apps.connectors.googlesheets.GoogleSheetsAppSyncConfig;
import io.castled.apps.connectors.googlesheets.GoogleSheetsObjectSink;
import io.castled.apps.models.DataSinkRequest;
import io.castled.commons.models.AppSyncStats;
import io.castled.models.QueryMode;
import io.castled.schema.models.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;

public class GoogleSheetsDataSink
implements DataSink {
    private GoogleSheetsObjectSink googleSheetsObjectSink;

    @Override
    public void syncRecords(DataSinkRequest dataSinkRequest) throws Exception {
        Message message;
        GoogleSheetsAppConfig googleSheetsAppConfig = (GoogleSheetsAppConfig)dataSinkRequest.getExternalApp().getConfig();
        GoogleSheetsAppSyncConfig googleSheetsAppSyncConfig = (GoogleSheetsAppSyncConfig)dataSinkRequest.getAppSyncConfig();
        Sheets sheetsService = GoogleSheetUtils.getSheets(googleSheetsAppConfig.getServiceAccount());
        if (dataSinkRequest.getQueryMode() == QueryMode.FULL_LOAD) {
            sheetsService.spreadsheets().values().clear(GoogleSheetUtils.getSpreadSheetId(googleSheetsAppConfig.getSpreadSheetId()), googleSheetsAppSyncConfig.getObject().getObjectName(), new ClearValuesRequest()).execute();
        }
        ArrayList sheetRows = dataSinkRequest.getQueryMode() == QueryMode.FULL_LOAD ? Lists.newArrayList() : GoogleSheetUtils.getRows(sheetsService, GoogleSheetUtils.getSpreadSheetId(googleSheetsAppConfig.getSpreadSheetId()), googleSheetsAppSyncConfig.getObject().getObjectName());
        this.googleSheetsObjectSink = new GoogleSheetsObjectSink(googleSheetsAppConfig, googleSheetsAppSyncConfig, sheetsService, sheetRows, dataSinkRequest.getPrimaryKeys(), dataSinkRequest.getMappedFields(), dataSinkRequest.getErrorOutputStream());
        int recordsCount = 0;
        while ((message = dataSinkRequest.getMessageInputStream().readMessage()) != null) {
            if (recordsCount == 0 && CollectionUtils.isEmpty((Collection)sheetRows)) {
                sheetsService.spreadsheets().values().append(GoogleSheetUtils.getSpreadSheetId(googleSheetsAppConfig.getSpreadSheetId()), googleSheetsAppSyncConfig.getObject().getObjectName(), new ValueRange().setValues(Collections.singletonList(new ArrayList<String>(dataSinkRequest.getMappedFields())))).setValueInputOption("USER_ENTERED").execute();
            }
            this.googleSheetsObjectSink.writeRecord(message);
            ++recordsCount;
        }
        this.googleSheetsObjectSink.flushRecords();
    }

    @Override
    public AppSyncStats getSyncStats() {
        return Optional.ofNullable(this.googleSheetsObjectSink).map(audienceSinkRef -> this.googleSheetsObjectSink.getSyncStats()).map(statsRef -> new AppSyncStats(statsRef.getRecordsProcessed(), statsRef.getOffset(), 0L)).orElse(new AppSyncStats(0L, 0L, 0L));
    }
}

