/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.googleads;

import com.google.ads.googleads.v7.resources.ConversionCustomVariable;
import com.google.common.collect.Lists;
import io.castled.ObjectRegistry;
import io.castled.apps.ExternalAppConnector;
import io.castled.apps.connectors.googleads.CustomerMatchType;
import io.castled.apps.connectors.googleads.GAdsObjectType;
import io.castled.apps.connectors.googleads.GadsObjectFields;
import io.castled.apps.connectors.googleads.GoogleAdUtils;
import io.castled.apps.connectors.googleads.GoogleAdsAppConfig;
import io.castled.apps.connectors.googleads.GoogleAdsAppSyncConfig;
import io.castled.apps.connectors.googleads.GoogleAdsDataSink;
import io.castled.apps.models.ExternalAppSchema;
import io.castled.dtos.PipelineConfigDTO;
import io.castled.exceptions.CastledRuntimeException;
import io.castled.forms.dtos.FormFieldOption;
import io.castled.models.FieldMapping;
import io.castled.models.TargetFieldsMapping;
import io.castled.schema.SchemaConstants;
import io.castled.schema.models.RecordSchema;
import io.castled.schema.models.Schema;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.BadRequestException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.tuple.Pair;

public class GoogleAdsAppConnector
implements ExternalAppConnector<GoogleAdsAppConfig, GoogleAdsDataSink, GoogleAdsAppSyncConfig> {
    @Override
    public List<FormFieldOption> getAllObjects(GoogleAdsAppConfig config, GoogleAdsAppSyncConfig mappingConfig) {
        return Arrays.stream(GAdsObjectType.values()).map(this::getFormSelectOption).collect(Collectors.toList());
    }

    @Override
    public ExternalAppSchema getSchema(GoogleAdsAppConfig config, GoogleAdsAppSyncConfig mappingConfig) {
        switch (mappingConfig.getObjectType()) {
            case CUSTOMER_MATCH: {
                return this.getSchemaForCustomerMatch(mappingConfig.getCustomerMatchType());
            }
            case CLICK_CONVERSIONS: {
                return this.getSchemaForClickConversions(config, mappingConfig);
            }
            case CALL_CONVERSIONS: {
                return this.getSchemaForCallConversions(config, mappingConfig);
            }
        }
        throw new CastledRuntimeException(String.format("Unhandled object type %s", new Object[]{mappingConfig.getObjectType()}));
    }

    private Pair<String, String> getTitleAndDescription(GAdsObjectType gAdsObjectType) {
        switch (gAdsObjectType) {
            case CUSTOMER_MATCH: {
                return Pair.of((Object)"Customer match list", (Object)"Sync customized users list to the customer match list to be used in ad campaigns");
            }
            case CALL_CONVERSIONS: {
                return Pair.of((Object)"Call Conversions", (Object)"Sync call conversion metrics to the call conversions object for better evaluation of your ad campaigns");
            }
            case CLICK_CONVERSIONS: {
                return Pair.of((Object)"Click Conversions", (Object)"Sync click conversion metrics to the click conversions object for better evaluation of your ad campaigns");
            }
        }
        throw new CastledRuntimeException(String.format("Invalid google ads object type %s", new Object[]{gAdsObjectType}));
    }

    private FormFieldOption getFormSelectOption(GAdsObjectType gAdsObjectType) {
        Pair<String, String> titleAndDescription = this.getTitleAndDescription(gAdsObjectType);
        return new FormFieldOption((Object)gAdsObjectType, (String)titleAndDescription.getLeft(), (String)titleAndDescription.getRight());
    }

    @Override
    public GoogleAdsDataSink getDataSink() {
        return (GoogleAdsDataSink)ObjectRegistry.getInstance(GoogleAdsDataSink.class);
    }

    private ExternalAppSchema getSchemaForCallConversions(GoogleAdsAppConfig googleAdsAppConfig, GoogleAdsAppSyncConfig mappingConfig) {
        RecordSchema.Builder customerSchemaBuilder = RecordSchema.builder();
        for (GadsObjectFields.CALL_CONVERSION_STANDARD_FIELDS field : GadsObjectFields.CALL_CONVERSION_STANDARD_FIELDS.values()) {
            customerSchemaBuilder.put(field.getFieldName(), field.getSchema());
        }
        for (String customVariable : GoogleAdUtils.getCustomVariables(googleAdsAppConfig, mappingConfig).stream().map(ConversionCustomVariable::getName).collect(Collectors.toList())) {
            customerSchemaBuilder.put(customVariable, (Schema)SchemaConstants.OPTIONAL_STRING_SCHEMA);
        }
        return new ExternalAppSchema(customerSchemaBuilder.build(), Lists.newArrayList((Object[])new String[]{GadsObjectFields.CALL_CONVERSION_STANDARD_FIELDS.CALLER_ID.getFieldName()}));
    }

    private ExternalAppSchema getSchemaForClickConversions(GoogleAdsAppConfig googleAdsAppConfig, GoogleAdsAppSyncConfig googleAdsMappingConfig) {
        RecordSchema.Builder recordSchemaBuilder = RecordSchema.builder();
        for (GadsObjectFields.CLICK_CONVERSION_STANDARD_FIELDS field : GadsObjectFields.CLICK_CONVERSION_STANDARD_FIELDS.values()) {
            recordSchemaBuilder.put(field.getFieldName(), field.getSchema());
        }
        for (String customVariable : GoogleAdUtils.getCustomVariables(googleAdsAppConfig, googleAdsMappingConfig).stream().map(ConversionCustomVariable::getName).collect(Collectors.toList())) {
            recordSchemaBuilder.put(customVariable, (Schema)SchemaConstants.OPTIONAL_STRING_SCHEMA);
        }
        return new ExternalAppSchema(recordSchemaBuilder.build(), Lists.newArrayList((Object[])new String[]{GadsObjectFields.CLICK_CONVERSION_STANDARD_FIELDS.GCLID.getFieldName()}));
    }

    private ExternalAppSchema getSchemaForCustomerMatch(CustomerMatchType customerMatchType) {
        switch (customerMatchType) {
            case CONTACT_INFO: {
                RecordSchema.Builder customerSchemaBuilder = RecordSchema.builder();
                for (GadsObjectFields.CUSTOMER_MATCH_CONTACT_INFO_FIELDS customerMatchField : GadsObjectFields.CUSTOMER_MATCH_CONTACT_INFO_FIELDS.values()) {
                    customerSchemaBuilder.put(customerMatchField.getFieldName(), (Schema)SchemaConstants.OPTIONAL_STRING_SCHEMA);
                }
                ArrayList pkEligibles = Lists.newArrayList((Object[])new String[]{GadsObjectFields.CUSTOMER_MATCH_CONTACT_INFO_FIELDS.EMAIL.getFieldName(), GadsObjectFields.CUSTOMER_MATCH_CONTACT_INFO_FIELDS.PHONE_NUMBER.getFieldName()});
                return new ExternalAppSchema(customerSchemaBuilder.build(), pkEligibles);
            }
            case CRM_ID: {
                RecordSchema.Builder userIdSchemaBuilder = RecordSchema.builder().put("User Id", (Schema)SchemaConstants.STRING_SCHEMA);
                return new ExternalAppSchema(userIdSchemaBuilder.build(), Lists.newArrayList((Object[])new String[]{"User Id"}));
            }
            case MOBILE_ADVERTISING_ID: {
                RecordSchema.Builder mobileIdSchemaBuilder = RecordSchema.builder().put("Mobile Device Id", (Schema)SchemaConstants.STRING_SCHEMA);
                return new ExternalAppSchema(mobileIdSchemaBuilder.build(), Lists.newArrayList((Object[])new String[]{"Mobile Device Id"}));
            }
        }
        throw new CastledRuntimeException(String.format("Invalid customer match type %s", new Object[]{customerMatchType}));
    }

    @Override
    public PipelineConfigDTO validateAndEnrichPipelineConfig(PipelineConfigDTO pipelineConfig) throws BadRequestException {
        TargetFieldsMapping targetFieldsMapping = (TargetFieldsMapping)pipelineConfig.getMapping();
        List mappedAppFields = targetFieldsMapping.getFieldMappings().stream().map(FieldMapping::getAppField).collect(Collectors.toList());
        GAdsObjectType gAdsObjectType = ((GoogleAdsAppSyncConfig)pipelineConfig.getAppSyncConfig()).getObjectType();
        List<String> requiredFields = this.getRequiredFields(gAdsObjectType);
        List missingFields = ListUtils.subtract(requiredFields, mappedAppFields);
        if (CollectionUtils.isNotEmpty((Collection)missingFields)) {
            throw new BadRequestException(String.format("Mandatory fields %s not mapped", String.join((CharSequence)",", missingFields)));
        }
        return pipelineConfig;
    }

    private List<String> getRequiredFields(GAdsObjectType gAdsObjectType) {
        switch (gAdsObjectType) {
            case CLICK_CONVERSIONS: {
                return Lists.newArrayList((Object[])new String[]{GadsObjectFields.CLICK_CONVERSION_STANDARD_FIELDS.CONVERSION_TIME.getFieldName(), GadsObjectFields.CLICK_CONVERSION_STANDARD_FIELDS.GCLID.getFieldName()});
            }
            case CALL_CONVERSIONS: {
                return Lists.newArrayList((Object[])new String[]{GadsObjectFields.CALL_CONVERSION_STANDARD_FIELDS.CONVERSION_TIME.getFieldName(), GadsObjectFields.CALL_CONVERSION_STANDARD_FIELDS.CALLER_ID.getFieldName(), GadsObjectFields.CALL_CONVERSION_STANDARD_FIELDS.CALL_START_TIME.getFieldName()});
            }
        }
        return Lists.newArrayList();
    }

    @Override
    public Class<GoogleAdsAppSyncConfig> getMappingConfigType() {
        return GoogleAdsAppSyncConfig.class;
    }

    @Override
    public Class<GoogleAdsAppConfig> getAppConfigType() {
        return GoogleAdsAppConfig.class;
    }
}

