/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.googleads;

import com.google.ads.googleads.lib.GoogleAdsClient;
import com.google.ads.googleads.v7.resources.ConversionCustomVariable;
import com.google.ads.googleads.v7.services.CallConversion;
import com.google.ads.googleads.v7.services.ClickConversion;
import com.google.ads.googleads.v7.services.ConversionUploadServiceClient;
import com.google.ads.googleads.v7.services.CustomVariable;
import com.google.ads.googleads.v7.services.UploadCallConversionsRequest;
import com.google.ads.googleads.v7.services.UploadCallConversionsResponse;
import com.google.ads.googleads.v7.services.UploadClickConversionsRequest;
import com.google.ads.googleads.v7.services.UploadClickConversionsResponse;
import com.google.common.collect.Lists;
import io.castled.ObjectRegistry;
import io.castled.apps.connectors.googleads.GAdsObjectType;
import io.castled.apps.connectors.googleads.GadsObjectFields;
import io.castled.apps.connectors.googleads.GadsObjectSink;
import io.castled.apps.connectors.googleads.GoogleAdUtils;
import io.castled.apps.connectors.googleads.GoogleAdsAppConfig;
import io.castled.apps.connectors.googleads.GoogleAdsAppSyncConfig;
import io.castled.commons.errors.errorclassifications.MissingRequiredFieldsError;
import io.castled.commons.streams.ErrorOutputStream;
import io.castled.oauth.OAuthDetails;
import io.castled.schema.models.Field;
import io.castled.schema.models.Message;
import io.castled.schema.models.Tuple;
import io.castled.services.OAuthService;
import io.castled.utils.MessageUtils;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConversionObjectSink
extends GadsObjectSink {
    private static final Logger log = LoggerFactory.getLogger(ConversionObjectSink.class);
    private final GoogleAdsAppSyncConfig mappingConfig;
    private final ConversionUploadServiceClient conversionUploadServiceClient;
    private final List<ConversionCustomVariable> customVariables;

    public ConversionObjectSink(GoogleAdsAppSyncConfig mappingConfig, GoogleAdsAppConfig googleAdsAppConfig, ErrorOutputStream errorOutputStream) {
        super(errorOutputStream);
        this.mappingConfig = mappingConfig;
        OAuthDetails oAuthDetails = ((OAuthService)ObjectRegistry.getInstance(OAuthService.class)).getOAuthDetails(googleAdsAppConfig.getOAuthToken());
        GoogleAdsClient googleAdsClient = GoogleAdsClient.newBuilder().fromProperties(GoogleAdUtils.getClientProperties(googleAdsAppConfig, oAuthDetails.getAccessConfig().getRefreshToken(), mappingConfig.getLoginCustomerId())).build();
        this.conversionUploadServiceClient = googleAdsClient.getLatestVersion().createConversionUploadServiceClient();
        this.customVariables = GoogleAdUtils.getCustomVariables(googleAdsAppConfig, mappingConfig);
    }

    @Override
    public void writeRecords(List<Message> messages) {
        GAdsObjectType gAdsObjectType = this.mappingConfig.getObjectType();
        if (gAdsObjectType == GAdsObjectType.CLICK_CONVERSIONS) {
            this.uploadClickConversions(messages);
        } else {
            this.uploadCallConversions(messages);
        }
        this.processedRecords.addAndGet(messages.size());
        this.lastProcessedMessageId = Math.min(this.lastProcessedMessageId, messages.get(messages.size() - 1).getOffset());
    }

    private void uploadClickConversions(List<Message> messages) {
        ArrayList clickConversions = Lists.newArrayList();
        for (Message message : messages) {
            ClickConversion clickConversion = this.getClickConversion(message);
            if (!clickConversion.hasConversionDateTime()) {
                this.errorOutputStream.writeFailedRecord(message, new MissingRequiredFieldsError(Lists.newArrayList((Object[])new String[]{GadsObjectFields.CLICK_CONVERSION_STANDARD_FIELDS.CONVERSION_TIME.getFieldName()})));
                continue;
            }
            if (!clickConversion.hasGclid()) {
                this.errorOutputStream.writeFailedRecord(message, new MissingRequiredFieldsError(Lists.newArrayList((Object[])new String[]{GadsObjectFields.CLICK_CONVERSION_STANDARD_FIELDS.GCLID.getFieldName()})));
                continue;
            }
            clickConversions.add(clickConversion);
        }
        UploadClickConversionsResponse response = this.conversionUploadServiceClient.uploadClickConversions(UploadClickConversionsRequest.newBuilder().setCustomerId(String.valueOf(this.mappingConfig.getAccountId())).addAllConversions((Iterable)clickConversions).setPartialFailure(true).build());
        if (response.hasPartialFailureError()) {
            this.handlePartialFailures(messages, response.getPartialFailureError());
        }
    }

    private ClickConversion getClickConversion(Message message) {
        Tuple record = message.getRecord();
        Double conversionValue = (Double)record.getValue(GadsObjectFields.CLICK_CONVERSION_STANDARD_FIELDS.CONVERSION_VALUE.getFieldName());
        String orderId = (String)record.getValue(GadsObjectFields.CLICK_CONVERSION_STANDARD_FIELDS.ORDER_ID.getFieldName());
        String gclId = (String)record.getValue(GadsObjectFields.CLICK_CONVERSION_STANDARD_FIELDS.GCLID.getFieldName());
        String currencyCode = (String)record.getValue(GadsObjectFields.CLICK_CONVERSION_STANDARD_FIELDS.CURRENCY_CODE.getFieldName());
        LocalDateTime conversionTime = (LocalDateTime)record.getValue(GadsObjectFields.CLICK_CONVERSION_STANDARD_FIELDS.CONVERSION_TIME.getFieldName());
        String conversionDateTimeString = Optional.ofNullable(conversionTime).map(this::formatTimestampField).orElse(null);
        ClickConversion.Builder builder = ClickConversion.newBuilder().setConversionAction(this.mappingConfig.getClickConversion().getResourceName());
        Optional.ofNullable(gclId).ifPresent(arg_0 -> ((ClickConversion.Builder)builder).setGclid(arg_0));
        Optional.ofNullable(conversionValue).ifPresent(arg_0 -> ((ClickConversion.Builder)builder).setConversionValue(arg_0));
        Optional.ofNullable(orderId).ifPresent(arg_0 -> ((ClickConversion.Builder)builder).setOrderId(arg_0));
        Optional.ofNullable(currencyCode).ifPresent(arg_0 -> ((ClickConversion.Builder)builder).setCurrencyCode(arg_0));
        Optional.ofNullable(conversionDateTimeString).ifPresent(arg_0 -> ((ClickConversion.Builder)builder).setConversionDateTime(arg_0));
        for (ConversionCustomVariable customVariable : this.customVariables) {
            String customVariableValue = MessageUtils.toString((Field)record.getField(customVariable.getName()));
            Optional.ofNullable(customVariableValue).ifPresent(valueRef -> builder.addCustomVariables(CustomVariable.newBuilder().setConversionCustomVariable(customVariable.getResourceName()).setValue(valueRef)));
        }
        return builder.build();
    }

    private String formatTimestampField(LocalDateTime localDateTime) {
        ZonedDateTime zonedDateTime = ZonedDateTime.of(localDateTime, ZoneId.of(this.mappingConfig.getZoneId()));
        return zonedDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ssxxx"));
    }

    private CallConversion getCallConversion(Message message) {
        Tuple record = message.getRecord();
        Double conversionValue = (Double)record.getValue(GadsObjectFields.CALL_CONVERSION_STANDARD_FIELDS.CONVERSION_VALUE.getFieldName());
        String callerId = (String)record.getValue(GadsObjectFields.CALL_CONVERSION_STANDARD_FIELDS.CALLER_ID.getFieldName());
        String currencyCode = (String)record.getValue(GadsObjectFields.CALL_CONVERSION_STANDARD_FIELDS.CURRENCY_CODE.getFieldName());
        LocalDateTime conversionDateTime = (LocalDateTime)record.getValue(GadsObjectFields.CALL_CONVERSION_STANDARD_FIELDS.CONVERSION_TIME.getFieldName());
        String conversionDateTimeString = Optional.ofNullable(conversionDateTime).map(this::formatTimestampField).orElse(null);
        LocalDateTime callStartTime = (LocalDateTime)record.getValue(GadsObjectFields.CALL_CONVERSION_STANDARD_FIELDS.CALL_START_TIME.getFieldName());
        String callStartTimeString = Optional.ofNullable(callStartTime).map(this::formatTimestampField).orElse(null);
        CallConversion.Builder builder = CallConversion.newBuilder().setConversionAction(this.mappingConfig.getCallConversion().getResourceName());
        Optional.ofNullable(callerId).ifPresent(arg_0 -> ((CallConversion.Builder)builder).setCallerId(arg_0));
        Optional.ofNullable(conversionValue).ifPresent(arg_0 -> ((CallConversion.Builder)builder).setConversionValue(arg_0));
        Optional.ofNullable(currencyCode).ifPresent(arg_0 -> ((CallConversion.Builder)builder).setCurrencyCode(arg_0));
        Optional.ofNullable(conversionDateTimeString).ifPresent(arg_0 -> ((CallConversion.Builder)builder).setConversionDateTime(arg_0));
        Optional.ofNullable(callStartTimeString).ifPresent(arg_0 -> ((CallConversion.Builder)builder).setCallStartDateTime(arg_0));
        for (ConversionCustomVariable customVariable : this.customVariables) {
            String customVariableValue = (String)record.getValue(customVariable.getName());
            Optional.ofNullable(customVariableValue).ifPresent(valueRef -> builder.addCustomVariables(CustomVariable.newBuilder().setConversionCustomVariable(customVariable.getResourceName()).setValue(valueRef)));
        }
        return builder.build();
    }

    private void uploadCallConversions(List<Message> messages) {
        ArrayList callConversions = Lists.newArrayList();
        for (Message message : messages) {
            CallConversion callConversion = this.getCallConversion(message);
            if (!callConversion.hasConversionDateTime()) {
                this.errorOutputStream.writeFailedRecord(message, new MissingRequiredFieldsError(Lists.newArrayList((Object[])new String[]{GadsObjectFields.CALL_CONVERSION_STANDARD_FIELDS.CONVERSION_TIME.getFieldName()})));
                continue;
            }
            if (!callConversion.hasCallerId()) {
                this.errorOutputStream.writeFailedRecord(message, new MissingRequiredFieldsError(Lists.newArrayList((Object[])new String[]{GadsObjectFields.CALL_CONVERSION_STANDARD_FIELDS.CALLER_ID.getFieldName()})));
                continue;
            }
            if (!callConversion.hasCallStartDateTime()) {
                this.errorOutputStream.writeFailedRecord(message, new MissingRequiredFieldsError(Lists.newArrayList((Object[])new String[]{GadsObjectFields.CALL_CONVERSION_STANDARD_FIELDS.CALL_START_TIME.getFieldName()})));
                continue;
            }
            callConversions.add(callConversion);
        }
        UploadCallConversionsResponse response = this.conversionUploadServiceClient.uploadCallConversions(UploadCallConversionsRequest.newBuilder().setCustomerId(this.mappingConfig.getAccountId()).addAllConversions((Iterable)callConversions).setPartialFailure(true).build());
        if (response.hasPartialFailureError()) {
            this.handlePartialFailures(messages, response.getPartialFailureError());
        }
    }
}

