/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.fbcustomaudience.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import io.castled.ObjectRegistry;
import io.castled.apps.connectors.fbcustomaudience.FbAccessConfig;
import io.castled.apps.connectors.fbcustomaudience.FbAppConfig;
import io.castled.apps.connectors.fbcustomaudience.FbCustomAudAppSyncConfig;
import io.castled.apps.connectors.fbcustomaudience.FbCustomerErrors;
import io.castled.apps.connectors.fbcustomaudience.client.FbClientUtils;
import io.castled.apps.connectors.fbcustomaudience.client.dtos.AdAccount;
import io.castled.apps.connectors.fbcustomaudience.client.dtos.CustomAudienceCreateRequest;
import io.castled.apps.connectors.fbcustomaudience.client.dtos.CustomAudienceListResponse;
import io.castled.apps.connectors.fbcustomaudience.client.dtos.CustomAudienceResponse;
import io.castled.apps.connectors.fbcustomaudience.client.dtos.CustomerListPayload;
import io.castled.apps.connectors.fbcustomaudience.client.dtos.CustomerListResponse;
import io.castled.apps.connectors.fbcustomaudience.client.dtos.FbAdAccountResponse;
import io.castled.apps.connectors.fbcustomaudience.client.dtos.SessionInfo;
import io.castled.exceptions.CastledRuntimeException;
import io.castled.oauth.OAuthDetails;
import io.castled.services.OAuthService;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;

public class FbRestClient {
    private static final String API_ENDPOINT = "https://graph.facebook.com/v13.0";
    private static final String USER_ID = "me";
    private static final long BATCH_SIZE = 10000L;
    private final Client client = (Client)ObjectRegistry.getInstance(Client.class);
    private final FbAppConfig appConfig;
    private final FbCustomAudAppSyncConfig appSyncConfig;
    private FbAccessConfig oauthAccessConfig;
    private OAuthDetails oAuthDetails;
    private SessionInfo sessionInfo;

    public FbRestClient(FbAppConfig appConfig, FbCustomAudAppSyncConfig appSyncConfig) {
        this.appConfig = appConfig;
        this.appSyncConfig = appSyncConfig;
        this.oAuthDetails = ((OAuthService)ObjectRegistry.getInstance(OAuthService.class)).getOAuthDetails(appConfig.getOAuthToken());
        this.oauthAccessConfig = (FbAccessConfig)this.oAuthDetails.getAccessConfig();
        this.sessionInfo = new SessionInfo(Instant.now().getEpochSecond(), 0, false, 0);
    }

    public List<AdAccount> getAllAdAccounts() {
        String FIELD_NAME = "name";
        String nextApiUrl = String.format("%s/%s/adaccounts", API_ENDPOINT, USER_ID);
        ArrayList adAccounts = Lists.newArrayList();
        while (nextApiUrl != null && !nextApiUrl.isEmpty()) {
            String url = nextApiUrl;
            Response response = FbClientUtils.executeAndHandleError(() -> this.client.target(url).queryParam("fields", new Object[]{"name"}).queryParam("access_token", new Object[]{this.oAuthDetails.getAccessConfig().getAccessToken()}).request(new String[]{"application/json"}).get());
            FbAdAccountResponse accountResponse = (FbAdAccountResponse)response.readEntity(FbAdAccountResponse.class);
            adAccounts.addAll(accountResponse.getData());
            nextApiUrl = accountResponse.getPaging().getNext();
        }
        return adAccounts;
    }

    public CustomAudienceResponse createCustomAudience(String audienceName) {
        CustomAudienceCreateRequest request = new CustomAudienceCreateRequest(audienceName, "CUSTOM", "", "USER_PROVIDED_ONLY", this.oAuthDetails.getAccessConfig().getAccessToken());
        Form form = new Form().param("name", audienceName).param("subtype", "CUSTOM").param("description", "").param("customer_file_source", "USER_PROVIDED_ONLY").param("access_token", this.oAuthDetails.getAccessConfig().getAccessToken());
        Response response = FbClientUtils.executeAndHandleError(() -> this.client.target(String.format("%s/%s/customaudiences", API_ENDPOINT, this.appSyncConfig.getAccountId())).request(new String[]{"application/json"}).post(Entity.form((Form)form)));
        CustomAudienceResponse audResponse = (CustomAudienceResponse)response.readEntity(CustomAudienceResponse.class);
        return audResponse;
    }

    public Optional<CustomAudienceResponse> getCustomAudience(String audienceName) {
        Response response = FbClientUtils.executeAndHandleError(() -> this.client.target(String.format("%s/%s/customaudiences", API_ENDPOINT, this.appSyncConfig.getAccountId())).queryParam("fields", new Object[]{"name"}).queryParam("access_token", new Object[]{this.oAuthDetails.getAccessConfig().getAccessToken()}).request(new String[]{"application/json"}).get());
        CustomAudienceListResponse audResponse = (CustomAudienceListResponse)response.readEntity(CustomAudienceListResponse.class);
        Optional<CustomAudienceResponse> audience = audResponse.getData().stream().filter(aud -> audienceName.equals(aud.getName())).findFirst();
        return audience;
    }

    public String getOrCreateCustomAudienceId(String audienceName) {
        Optional<CustomAudienceResponse> audienceResponse = this.getCustomAudience(audienceName);
        CustomAudienceResponse audience = audienceResponse.isPresent() ? audienceResponse.get() : this.createCustomAudience(audienceName);
        return audience.getId();
    }

    public FbCustomerErrors addCustomerList(List<String> schema, List<List<String>> data) {
        String customAudienceId = this.getOrCreateCustomAudienceId(this.appSyncConfig.getCustomAudienceName());
        CustomerListPayload payload = new CustomerListPayload(schema, data);
        ObjectMapper objMapper = new ObjectMapper();
        this.sessionInfo.setBatchSeq(this.sessionInfo.getBatchSeq() + 1);
        this.sessionInfo.setEstimatedNumTotal(data.size());
        this.sessionInfo.setLastBatchFlag((long)data.size() < 10000L);
        Form form = new Form();
        try {
            form.param("access_token", this.oAuthDetails.getAccessConfig().getAccessToken());
            form.param("session", objMapper.writeValueAsString((Object)this.sessionInfo));
            form.param("payload", objMapper.writeValueAsString((Object)payload));
        }
        catch (JsonProcessingException e) {
            throw new CastledRuntimeException((Throwable)e);
        }
        Response response = FbClientUtils.executeAndHandleError(() -> this.client.target(String.format("%s/%s/users", API_ENDPOINT, customAudienceId)).request(new String[]{"application/json"}).post(Entity.form((Form)form)));
        CustomerListResponse listResponse = (CustomerListResponse)response.readEntity(CustomerListResponse.class);
        return new FbCustomerErrors(listResponse.getNumInvalidEntries(), listResponse.getInvalidEntrySamples());
    }
}

