/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.fbcustomaudience;

import io.castled.ObjectRegistry;
import io.castled.apps.connectors.fbcustomaudience.FbAccessConfig;
import io.castled.apps.connectors.fbcustomaudience.client.FbAuthClient;
import io.castled.apps.connectors.fbcustomaudience.client.dtos.FbTokenResponse;
import io.castled.cache.OAuthCache;
import io.castled.oauth.AccessTokenRefresher;
import io.castled.oauth.OAuthClientConfig;
import io.castled.oauth.OAuthDAO;
import io.castled.oauth.OAuthDetails;
import io.castled.pubsub.MessagePublisher;
import io.castled.pubsub.registry.Message;
import io.castled.pubsub.registry.OAuthDetailsUpdatedMessage;
import java.time.Instant;
import org.jdbi.v3.core.Jdbi;

public class FbTokenRefresher
implements AccessTokenRefresher<FbAccessConfig> {
    private final OAuthDAO oAuthDAO = (OAuthDAO)((Jdbi)ObjectRegistry.getInstance(Jdbi.class)).onDemand(OAuthDAO.class);
    private final FbAuthClient fbAuthClient = (FbAuthClient)ObjectRegistry.getInstance(FbAuthClient.class);
    private final OAuthClientConfig oAuthClientConfig;
    private final OAuthCache oAuthCache;
    private final MessagePublisher messagePublisher;

    FbTokenRefresher(OAuthClientConfig oAuthClientConfig) {
        this.oAuthClientConfig = oAuthClientConfig;
        this.oAuthCache = (OAuthCache)((Object)ObjectRegistry.getInstance(OAuthCache.class));
        this.messagePublisher = (MessagePublisher)ObjectRegistry.getInstance(MessagePublisher.class);
    }

    @Override
    public FbAccessConfig refreshAndPersistAccessConfig(Long oAuthToken) {
        OAuthDetails oAuthDetails = (OAuthDetails)this.oAuthCache.getValue(oAuthToken);
        FbTokenResponse fbTokenResponse = this.fbAuthClient.renewToken(oAuthDetails.getAccessConfig().getAccessToken(), this.oAuthClientConfig.getClientId(), this.oAuthClientConfig.getClientSecret());
        FbAccessConfig fbAccessConfig = FbAccessConfig.builder().accessToken(fbTokenResponse.getAccessToken()).expiresIn(fbTokenResponse.getExpiresIn()).tokenEpochSecond(Instant.now().getEpochSecond()).build();
        this.oAuthDAO.updateAccessConfig(oAuthToken, fbAccessConfig);
        this.messagePublisher.publishMessage((Message)new OAuthDetailsUpdatedMessage(oAuthToken));
        return fbAccessConfig;
    }
}

