/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.customerio;

import com.google.common.collect.Lists;
import com.google.inject.Singleton;
import io.castled.ObjectRegistry;
import io.castled.apps.ExternalAppConnector;
import io.castled.apps.ExternalAppType;
import io.castled.apps.connectors.customerio.CustomerIOAppConfig;
import io.castled.apps.connectors.customerio.CustomerIOAppSyncConfig;
import io.castled.apps.connectors.customerio.CustomerIODataSink;
import io.castled.apps.connectors.customerio.CustomerIOObject;
import io.castled.apps.connectors.customerio.CustomerIOObjectFields;
import io.castled.apps.models.ExternalAppSchema;
import io.castled.apps.models.GenericSyncObject;
import io.castled.apps.models.PrimaryKeyEligibles;
import io.castled.commons.models.AppSyncMode;
import io.castled.dtos.PipelineConfigDTO;
import io.castled.forms.dtos.FormFieldOption;
import io.castled.models.FieldMapping;
import io.castled.models.TargetFieldsMapping;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.ws.rs.BadRequestException;

@Singleton
public class CustomerIOAppConnector
implements ExternalAppConnector<CustomerIOAppConfig, CustomerIODataSink, CustomerIOAppSyncConfig> {
    @Override
    public List<FormFieldOption> getAllObjects(CustomerIOAppConfig config, CustomerIOAppSyncConfig customerIOAppSyncConfig) {
        return Arrays.stream(CustomerIOObject.values()).map(customerIOObject -> new FormFieldOption((Object)new GenericSyncObject(customerIOObject.getName(), ExternalAppType.CUSTOMERIO), customerIOObject.getName())).collect(Collectors.toList());
    }

    @Override
    public CustomerIODataSink getDataSink() {
        return (CustomerIODataSink)ObjectRegistry.getInstance(CustomerIODataSink.class);
    }

    @Override
    public ExternalAppSchema getSchema(CustomerIOAppConfig config, CustomerIOAppSyncConfig customerIOAppSyncConfig) {
        return new ExternalAppSchema(null, PrimaryKeyEligibles.autoDetect());
    }

    @Override
    public List<AppSyncMode> getSyncModes(CustomerIOAppConfig config, CustomerIOAppSyncConfig customerIOAppSyncConfig) {
        String object = customerIOAppSyncConfig.getObject().getObjectName();
        if (CustomerIOObject.EVENT.getName().equalsIgnoreCase(object)) {
            return Lists.newArrayList((Object[])new AppSyncMode[]{AppSyncMode.INSERT});
        }
        if (CustomerIOObject.PERSON.getName().equalsIgnoreCase(object)) {
            return Lists.newArrayList((Object[])new AppSyncMode[]{AppSyncMode.UPSERT});
        }
        return Lists.newArrayList((Object[])new AppSyncMode[]{AppSyncMode.INSERT, AppSyncMode.UPSERT, AppSyncMode.UPDATE});
    }

    @Override
    public Class<CustomerIOAppSyncConfig> getMappingConfigType() {
        return CustomerIOAppSyncConfig.class;
    }

    @Override
    public Class<CustomerIOAppConfig> getAppConfigType() {
        return CustomerIOAppConfig.class;
    }

    @Override
    public PipelineConfigDTO validateAndEnrichPipelineConfig(PipelineConfigDTO pipelineConfig) throws BadRequestException {
        CustomerIOAppSyncConfig customerIOAppSyncConfig = (CustomerIOAppSyncConfig)pipelineConfig.getAppSyncConfig();
        String objectName = ((CustomerIOAppSyncConfig)pipelineConfig.getAppSyncConfig()).getObject().getObjectName();
        if (CustomerIOObject.EVENT.getName().equalsIgnoreCase(objectName)) {
            this.enrichPipelineConfigForEventObject(pipelineConfig, customerIOAppSyncConfig);
        }
        if (CustomerIOObject.PERSON.getName().equalsIgnoreCase(objectName)) {
            this.enrichPipelineConfigForPersonObject(pipelineConfig, customerIOAppSyncConfig);
        }
        return pipelineConfig;
    }

    private void enrichPipelineConfigForPersonObject(PipelineConfigDTO pipelineConfig, CustomerIOAppSyncConfig customerIOAppSyncConfig) throws BadRequestException {
        String pk = Optional.ofNullable(customerIOAppSyncConfig.getPrimaryKey()).orElseThrow(() -> new BadRequestException("Primary key for the Destination App Record is mandatory"));
        String personIdentifier = Optional.ofNullable(customerIOAppSyncConfig.getPersonIdentifier()).orElseThrow(() -> new BadRequestException("Column uniquely identifying the Person Records is mandatory"));
        FieldMapping primaryKeyFieldMapping = ((TargetFieldsMapping)pipelineConfig.getMapping()).getFieldMappings().stream().filter(fieldMapping -> fieldMapping.getWarehouseField().equalsIgnoreCase(personIdentifier)).findFirst().orElseThrow(() -> new BadRequestException("Mapping missing for the Destination App primary key"));
        if (CustomerIOObjectFields.CONTACTS_FIELDS.EMAIL.getFieldName().equalsIgnoreCase(pk)) {
            primaryKeyFieldMapping.setAppField(CustomerIOObjectFields.CONTACTS_FIELDS.EMAIL.getFieldName());
            pipelineConfig.getMapping().setPrimaryKeys(Collections.singletonList(CustomerIOObjectFields.CONTACTS_FIELDS.EMAIL.getFieldName()));
        }
        if (CustomerIOObjectFields.CONTACTS_FIELDS.ID.getFieldName().equalsIgnoreCase(pk)) {
            primaryKeyFieldMapping.setAppField(CustomerIOObjectFields.CONTACTS_FIELDS.ID.getFieldName());
            pipelineConfig.getMapping().setPrimaryKeys(Collections.singletonList(CustomerIOObjectFields.CONTACTS_FIELDS.ID.getFieldName()));
        }
    }

    private void enrichPipelineConfigForEventObject(PipelineConfigDTO pipelineConfig, CustomerIOAppSyncConfig customerIOAppSyncConfig) throws BadRequestException {
        FieldMapping primaryKeyFieldMapping = ((TargetFieldsMapping)pipelineConfig.getMapping()).getFieldMappings().stream().filter(fieldMapping -> fieldMapping.getWarehouseField().equalsIgnoreCase(customerIOAppSyncConfig.getEventId())).findFirst().orElseThrow(() -> new BadRequestException("Mapping missing for the Destination App primary key"));
        primaryKeyFieldMapping.setAppField(CustomerIOObjectFields.EVENT_FIELDS.EVENT_ID.getFieldName());
        String eventType = Optional.ofNullable(customerIOAppSyncConfig.getEventType()).orElseThrow(() -> new BadRequestException("Event type is mandatory"));
        if ("event".equalsIgnoreCase(eventType)) {
            ((TargetFieldsMapping)pipelineConfig.getMapping()).getFieldMappings().stream().filter(fieldMapping -> fieldMapping.getWarehouseField().equalsIgnoreCase(Optional.ofNullable(customerIOAppSyncConfig.getEventName()).orElseThrow(() -> new BadRequestException("Event Name is mandatory for Events")))).findFirst().ifPresent(fieldMapping -> fieldMapping.setAppField(CustomerIOObjectFields.EVENT_FIELDS.EVENT_NAME.getFieldName()));
        }
        if ("pageView".equalsIgnoreCase(eventType)) {
            ((TargetFieldsMapping)pipelineConfig.getMapping()).getFieldMappings().stream().filter(fieldMapping -> fieldMapping.getWarehouseField().equalsIgnoreCase(Optional.ofNullable(customerIOAppSyncConfig.getPageURL()).orElseThrow(() -> new BadRequestException("Page View is mandatory for Page View Events")))).findFirst().ifPresent(fieldMapping -> fieldMapping.setAppField(CustomerIOObjectFields.EVENT_FIELDS.PAGE_URL.getFieldName()));
        }
        pipelineConfig.getMapping().setPrimaryKeys(Collections.singletonList(CustomerIOObjectFields.EVENT_FIELDS.EVENT_ID.getFieldName()));
        ((TargetFieldsMapping)pipelineConfig.getMapping()).getFieldMappings().stream().filter(fieldMapping -> fieldMapping.getWarehouseField().equalsIgnoreCase(customerIOAppSyncConfig.getCustomerId())).findFirst().ifPresent(fieldMapping -> fieldMapping.setAppField(CustomerIOObjectFields.EVENT_FIELDS.CUSTOMER_ID.getFieldName()));
        ((TargetFieldsMapping)pipelineConfig.getMapping()).getFieldMappings().stream().filter(fieldMapping -> fieldMapping.getWarehouseField().equalsIgnoreCase(customerIOAppSyncConfig.getEventTimestamp())).findFirst().ifPresent(fieldMapping -> fieldMapping.setAppField(CustomerIOObjectFields.EVENT_FIELDS.EVENT_TIMESTAMP.getFieldName()));
    }
}

