/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.activecampaign;

import com.google.common.collect.ImmutableMap;
import io.castled.apps.connectors.activecampaign.ActiveCampaignObject;
import io.castled.apps.connectors.activecampaign.ActiveCampaignObjectFields;
import io.castled.apps.connectors.activecampaign.constant.ActiveCampaignConstants;
import io.castled.apps.connectors.activecampaign.dto.CustomDataAttribute;
import io.castled.schema.SchemaConstants;
import io.castled.schema.models.RecordSchema;
import io.castled.schema.models.Schema;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveCampaignUtils {
    private static final Logger log = LoggerFactory.getLogger(ActiveCampaignUtils.class);

    public static RecordSchema getSchema(ActiveCampaignObject activeCampaignObject, List<CustomDataAttribute> dataAttributes) {
        RecordSchema.Builder customerSchemaBuilder = RecordSchema.builder().name(activeCampaignObject.getName());
        for (ActiveCampaignObjectFields.CONTACTS_FIELDS field : ActiveCampaignObjectFields.CONTACTS_FIELDS.values()) {
            customerSchemaBuilder.put(field.getFieldName(), field.getSchema(), (Map)ImmutableMap.of((Object)ActiveCampaignConstants.CUSTOM_FIELD_ID, (Object)field.getFieldTitle(), (Object)ActiveCampaignConstants.CUSTOM_FIELD_INDICATOR, (Object)false));
        }
        for (CustomDataAttribute dataAttribute : dataAttributes) {
            customerSchemaBuilder.put(dataAttribute.getTitle(), (Schema)Optional.ofNullable(ActiveCampaignUtils.getFieldSchema(activeCampaignObject, dataAttribute)).orElse(null), (Map)ImmutableMap.of((Object)ActiveCampaignConstants.CUSTOM_FIELD_ID, (Object)dataAttribute.getId(), (Object)ActiveCampaignConstants.CUSTOM_FIELD_INDICATOR, (Object)true));
        }
        return customerSchemaBuilder.build();
    }

    public static Schema getFieldSchema(ActiveCampaignObject activeCampaignObject, CustomDataAttribute dataAttribute) {
        switch (dataAttribute.getType()) {
            case "textarea": {
                return SchemaConstants.OPTIONAL_STRING_SCHEMA;
            }
            case "text": {
                return SchemaConstants.OPTIONAL_STRING_SCHEMA;
            }
            case "dropdown": {
                return SchemaConstants.OPTIONAL_STRING_SCHEMA;
            }
            case "radio": {
                return SchemaConstants.OPTIONAL_BOOL_SCHEMA;
            }
            case "checkbox": {
                return SchemaConstants.OPTIONAL_BOOL_SCHEMA;
            }
            case "listbox": {
                return SchemaConstants.OPTIONAL_STRING_SCHEMA;
            }
            case "hidden": {
                return SchemaConstants.OPTIONAL_STRING_SCHEMA;
            }
            case "date": {
                return SchemaConstants.OPTIONAL_DATE_SCHEMA;
            }
            case "datetime": {
                return SchemaConstants.OPTIONAL_TIMESTAMP_SCHEMA;
            }
        }
        log.warn("Invalid data type %s", (Object)dataAttribute.getType());
        return null;
    }
}

